### R code from vignette source 'A23_AnnotationAndVisualization.Rnw'

###################################################
### code chunk number 1: setup
###################################################
options(digits=2)
library(SequenceAnalysisData)
library(org.Dm.eg.db)


###################################################
### code chunk number 2: select
###################################################
library(org.Dm.eg.db)
columns(org.Dm.eg.db)
keytypes(org.Dm.eg.db)
uniprotKeys <- head(keys(org.Dm.eg.db, keytype="UNIPROT"))
cols <- c("SYMBOL", "PATH")
select(org.Dm.eg.db, keys=uniprotKeys, columns=cols, keytype="UNIPROT")


###################################################
### code chunk number 3: select-kegg
###################################################
kegg <- select(org.Dm.eg.db, "00310", c("UNIPROT", "SYMBOL"), "PATH")
nrow(kegg)
head(kegg, 3)


###################################################
### code chunk number 4: tt-to-eg
###################################################
library(SequenceAnalysisData)
library(edgeR)
library(org.Dm.eg.db)
data(lrTest)
tt <- as.data.frame(topTags(lrTest))


###################################################
### code chunk number 5: tt-to-eg2
###################################################
fbids <- rownames(tt)
cols <- c("ENTREZID", "SYMBOL")
anno <- select(org.Dm.eg.db, fbids, cols, "FLYBASE")
ttanno <- merge(tt, anno, by.x=0, by.y="FLYBASE")
dim(ttanno)
head(ttanno, 3)


###################################################
### code chunk number 6: biomaRt1 (eval = FALSE)
###################################################
## library(biomaRt)
## head(listMarts(), 3)                      ## list the marts
## head(listDatasets(useMart("ensembl")), 3) ## mart datasets
## ensembl <-                                ## fully specified mart
##     useMart("ensembl", dataset = "hsapiens_gene_ensembl")
## 
## head(listFilters(ensembl), 3)             ## filters
## myFilter <- "chromosome_name"
## head(filterOptions(myFilter, ensembl), 3) ## return values
## myValues <- c("21", "22")
## head(listAttributes(ensembl), 3)          ## attributes
## myAttributes <- c("ensembl_gene_id","chromosome_name")
## 
## ## assemble and query the mart
## res <- getBM(attributes =  myAttributes, filters =  myFilter,
##              values =  myValues, mart = ensembl)


###################################################
### code chunk number 7: txdb
###################################################
library(TxDb.Dmelanogaster.UCSC.dm3.ensGene)
txdb <- TxDb.Dmelanogaster.UCSC.dm3.ensGene


###################################################
### code chunk number 8: de
###################################################
library(SequenceAnalysisData)
data(lrTest)
fbids <- rownames(topTags(lrTest))


###################################################
### code chunk number 9: flybase-tx-gn
###################################################
txnm <- select(txdb, fbids, "TXNAME", "GENEID")
nrow(txnm)
head(txnm, 3)


###################################################
### code chunk number 10: cdsBy
###################################################
txnm <- txnm[!is.na(txnm$TXNAME),,drop=FALSE]
cds <- cdsBy(txdb, "tx", use.names=TRUE)[txnm$TXNAME]
length(cds)
cds[1]


###################################################
### code chunk number 11: BSgenome
###################################################
library(BSgenome.Dmelanogaster.UCSC.dm3)
txx <- extractTranscriptsFromGenome(Dmelanogaster, cds)
length(txx)
head(txx, 3)
head(translate(txx), 3)


###################################################
### code chunk number 12: Gviz
###################################################
library(Gviz)
data(cpgIslands)
chr <- "chr7"
genome <- "hg19"


###################################################
### code chunk number 13: AnnotationTrack
###################################################
atrack <- AnnotationTrack(cpgIslands, name="CpG")
plotTracks(atrack)


###################################################
### code chunk number 14: GenomeAxisTrack
###################################################
gtrack <- GenomeAxisTrack()
plotTracks(list(gtrack, atrack))


###################################################
### code chunk number 15: IdeogramTrack
###################################################
itrack <- IdeogramTrack(genome=genome, chromosome=chr)
plotTracks(list(itrack, gtrack, atrack))


###################################################
### code chunk number 16: GeneRegionTrack
###################################################
data(geneModels)
grtrack <- 
    GeneRegionTrack(geneModels, genome=genome,
                    chromosome=chr, name="Gene Model")
tracks <- list(itrack, gtrack, atrack, grtrack)
plotTracks(tracks)


###################################################
### code chunk number 17: Gviz-zoom
###################################################
plotTracks(tracks, from=2.5e7, to=2.8e7)


###################################################
### code chunk number 18: Gviz-sequence
###################################################
library(BSgenome.Hsapiens.UCSC.hg19)
strack <- SequenceTrack(Hsapiens, chromosome=chr)
plotTracks(c(tracks, strack), from=26450430, to=26450490, cex=.8)


###################################################
### code chunk number 19: Gviz-data
###################################################
## some data
lim <- c(26700000, 26900000)
coords <- seq(lim[1], lim[2], 101)
dat <- runif(length(coords) - 1, min=-10, max=10)

## DataTrack
dtrack <- 
    DataTrack(data=dat, start=coords[-length(coords)],
              end= coords[-1], chromosome=chr, genome=genome,
              name="Uniform Random")
plotTracks(c(tracks, dtrack))


###################################################
### code chunk number 20: Gviz-figure
###################################################
pdf("GvizFigure.pdf")
plotTracks(c(tracks, dtrack))
xx <- capture.output(dev.off())


###################################################
### code chunk number 21: shiny-app
###################################################
library(shiny)
appDir <- system.file("shiny", 
    "AnnotationTable", package="StatisticalComputing2013")


###################################################
### code chunk number 22: shiny-run (eval = FALSE)
###################################################
## runApp(appDir)


###################################################
### code chunk number 23: ui
###################################################
noquote(readLines(file.path(appDir, "ui.R")))


###################################################
### code chunk number 24: shiny-install (eval = FALSE)
###################################################
## source("http://bioconductor.org/biocLite.R")
## biocLite("shiny")


