# Options:
# - Use the .R mechanism with data()
# - Define active bindings that download to getwd()

.onLoad <- function(libname, pkgName) {
  ns <- asNamespace(pkgName)

  delayedAssign("NA12878.20.fastq", .load_NA12878.20.fastq(),
                eval.env = ns, assign.env = ns)
  delayedAssign("NA12878.20.bam", .load_NA12878.20.bam(),
                eval.env = ns, assign.env = ns)
  delayedAssign("NA12878.20.vcf", .load_NA12878.20.vcf(),
                eval.env = ns, assign.env = ns)
  namespaceExport(ns, ls(ns)) 
}
