
## ----ShortRead, eval=FALSE, tidy=FALSE-----------------------------------
## ## Use the 'ShortRead' package
## library(ShortRead)
## ## Create an object to represent a sample from a file
## sampler <- FastqSampler("ERR127302_1.fastq.gz")
## ## Apply a method to yield a random sample
## fq <- yield(sampler)
## ## Access sequences of sampled reads using `sread()`
## ## Summarize nucleotide use by cycle
## ## 'abc' is a nucleotide x cycle matrix of counts
## abc <- alphabetByCycle(sread(fq))
## ## Subset of interesting nucleotides
## abc <- abc[c("A", "C", "G", "T", "N"),]


## ----ShortRead-vis, eval=FALSE, tidy=FALSE-------------------------------
## ## Create a plot from a
## ## matrix
## matplot(t(abc), type="l",
##   lty=1, lwd=3,
##   xlab="Cycle",
##   ylab="Count",
##   cex.lab=2)
## ## Add a legend
## legend("topright",
##   legend=rownames(abc),
##   lty=1, lwd=3, col=1:5,
##   cex=1.8)


