
## ----style, eval=TRUE, echo=FALSE, results="asis"------------------------
BiocStyle::latex()


## ----rbioc-pdata, echo=FALSE---------------------------------------------
pdataFile <- system.file(package="BiocIntro", "extdata", 
                         "pData.csv")


## ----rbioc-pdata-user, eval=FALSE----------------------------------------
## pdataFile <- "~/extdata/pData.csv"


## ----file-exists---------------------------------------------------------
stopifnot(file.exists(pdataFile))


## ----rbioc-pdata-csv-----------------------------------------------------
pdata <- read.table(pdataFile)  
dim(pdata)
names(pdata)
summary(pdata)


## ----rbioc-pdata-summarize-----------------------------------------------
head(pdata[,"sex"], 3)
head(pdata$sex, 3)
head(pdata[["sex"]], 3)
sapply(pdata, class)


## ----rbioc-pdata-sextab--------------------------------------------------
table(pdata$sex, useNA="ifany")


## ----rbioc-pdata-molbiol-------------------------------------------------
with(pdata, table(mol.biol, useNA="ifany"))


## ----rbbioc-pdata-bcrabl-------------------------------------------------
ridx <- pdata$mol.biol %in% c("BCR/ABL", "NEG")


## ----rbioc-pdata-molbiol-selected----------------------------------------
table(ridx)
sum(ridx)


## ----rbioc-pdata-subset--------------------------------------------------
pdata1 <- pdata[ridx,]


## ----rbioc-pdata-subset-levels-------------------------------------------
levels(pdata1$mol.biol)


## ----rbioc-pdata-subset-recode-------------------------------------------
pdata1$mol.biol <- factor(pdata1$mol.biol)
table(pdata1$mol.biol)


## ----rbioc-pdata-age-molbiol---------------------------------------------
with(pdata1, t.test(age ~ mol.biol))


## ----rbioc-pdata-boxplot, eval=FALSE-------------------------------------
## ## not evaluated
## boxplot(age ~ mol.biol, pdata1)


