
## ----style, eval=TRUE, echo=FALSE, results="asis"------------------------
BiocStyle::latex()
library(knitr)
opts_chunk$set(cache=TRUE, tidy=FALSE)


## ----loadgenome, message=FALSE-------------------------------------------
library(Gviz)
data(cpgIslands)
chr <- "chr7"
genome <- "hg19"


## ----plottrack, fig.height=3---------------------------------------------
atrack <- AnnotationTrack(cpgIslands, name="CpG")
plotTracks(atrack)


## ----plottrack2, fig.height=3--------------------------------------------
gtrack <- GenomeAxisTrack()
plotTracks(list(gtrack, atrack))


## ----plottrack3, fig.height=3--------------------------------------------
itrack <- IdeogramTrack(genome=genome, chromosome=chr)
plotTracks(list(itrack, gtrack, atrack))


## ----PLOT4---------------------------------------------------------------
data(geneModels)
grtrack <-
   GeneRegionTrack(geneModels, genome=genome,
   chromosome=chr, name="Gene Model")
tracks <- list(itrack, gtrack, atrack, grtrack)
plotTracks(tracks)


## ----plot5---------------------------------------------------------------
plotTracks(tracks, from=2.5e7, to=2.8e7)


## ----plot6---------------------------------------------------------------
library(BSgenome.Hsapiens.UCSC.hg19)
strack <- SequenceTrack(Hsapiens, chromosome=chr)
plotTracks(c(tracks, strack), from=26450430, to=26450490, cex=.8)


## ----plot7---------------------------------------------------------------
## some data
lim <- c(26700000, 26900000)
coords <- seq(lim[1], lim[2], 101)
dat <- runif(length(coords) - 1, min=-10, max=10)
## DataTrack
dtrack <-
 DataTrack(data=dat, start=coords[-length(coords)],
 end= coords[-1], chromosome=chr, genome=genome,
 name="Uniform Random")
plotTracks(c(tracks, dtrack))


