/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.fasta;

import com.gkano.bioinfo.fasta.CalculateD2ChildTask;
import com.gkano.bioinfo.fasta.CalculateD2Task;
import com.gkano.bioinfo.fasta.FastaManager;
import com.gkano.bioinfo.fasta.SequenceD2;
import com.gkano.bioinfo.var.Logger;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;

public class CalculateDistancesD2 {
    public static boolean verbose = false;

    public CalculateDistancesD2(boolean verbose) {
        CalculateDistancesD2.verbose = verbose;
        Logger.setVerbose(verbose);
    }

    public static void resetCounters() {
        CalculateD2ChildTask.resetCounters();
    }

    public double[][] calculateDistances(int numOfThreads, ConcurrentHashMap<Integer, SequenceD2> seqVectors, List<String> seqNames, List<Integer> seqIds, FastaManager frm) {
        try {
            int numOfSequences = seqNames.size();
            double[][] distances = new double[numOfSequences][numOfSequences];
            CalculateD2Task task = new CalculateD2Task(seqVectors, seqNames, seqIds, frm, distances);
            ForkJoinPool pool = new ForkJoinPool(numOfThreads);
            pool.execute(task);
            return (double[][])task.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

