% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_multiheatmaps}
\alias{plot_multiheatmaps}
\title{Visualize multivariate data by heatmaps.}
\usage{
plot_multiheatmaps(
  ssm_list = NULL,
  gem_list = NULL,
  ssmlabel_list = NULL,
  gemlabel_list = NULL,
  nrand_samples = NULL,
  show_row_names = FALSE,
  title = NULL
)
}
\arguments{
\item{ssm_list}{A list of sign-by-sample matrices.}

\item{gem_list}{A list of gene-by-sample matrices.}

\item{ssmlabel_list}{NULL or a list of dataframes of sample (cell)
labels and colors.
The length of the list must be as same as that of ssm_list, and
the order of labels in each list must be as same as those in ssm_list.}

\item{gemlabel_list}{NULL or a list of dataframes of sample (cell)
annotations and colors.
The length of the list must be as same as that of gem_list, and
the order of labels in each list must be as same as those in gem_list.}

\item{nrand_samples}{Number of samples (cells) used for random sampling.}

\item{show_row_names}{TRUE or FALSE: if TRUE, row names are shown.}

\item{title}{Title.}
}
\value{
A ComplexHeatmap object.
}
\description{
This function visualizes multivariate data by heatmaps.
}
\examples{
data(pbmcs_eg)
mat_CM <- SummarizedExperiment::assay(pbmcs_eg$CM, "counts")
mat_GO <- SummarizedExperiment::assay(pbmcs_eg$GO, "counts")
mat_KG <- SummarizedExperiment::assay(pbmcs_eg$KG, "counts")
ssm_list <- list(SSM_COMSig = mat_CM, SSM_GO = mat_GO, SSM_KEGG = mat_KG)
se <- SingleCellExperiment::altExp(pbmcs_eg$CM, "logcounts")
mat <- SummarizedExperiment::assay(se, "counts")
se <- SingleCellExperiment::altExp(pbmcs_eg$CM, "logcounts")
gem_list <- list(GeneExpr = SummarizedExperiment::assay(se, "counts"))
labels <- list() ; ssmlabel_list <- list()
for(i in seq_along(pbmcs_eg)){
  fa <- SummarizedExperiment::colData(pbmcs_eg[[i]])$seurat_clusters
  labels[[i]] <- data.frame(label = fa)
  colors <- rainbow(length(unique(labels[[i]]$label)))[labels[[i]]$label]
  labels[[i]]$color <- colors
  ssmlabel_list[[i]] <- labels[[i]]
}
names(ssmlabel_list) <- c("Label_COMSig", "Label_GO", "Label_KEGG")
phases <- SummarizedExperiment::colData(pbmcs_eg$CM)$Phase
label_CC <- data.frame(label = phases, color = NA)
gemlabel_list <- list(CellCycle = label_CC)
plot_multiheatmaps(ssm_list = ssm_list, gem_list = gem_list,
                   ssmlabel_list = ssmlabel_list,
                   gemlabel_list = gemlabel_list, nrand_samples = 50,
                   show_row_names = FALSE, title = "PBMC")

}
