% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_dataset.R
\name{new_nmr_dataset}
\alias{new_nmr_dataset}
\title{Create an nmr_dataset object}
\usage{
new_nmr_dataset(metadata, data_fields, axis)
}
\arguments{
\item{metadata}{A named list of data frames}

\item{data_fields}{A named list. Check the examples}

\item{axis}{A list. Check the examples}
}
\value{
Create an nmr_dataset object

Create an nmr_dataset object
}
\description{
Create an nmr_dataset object
}
\examples{
#
metadata_1D <- list(external = data.frame(NMRExperiment = c("10", "20")))
# Sample 10 and Sample 20 can have different lengths (due to different setups)
data_fields_1D <- list(data_1r = list(runif(16), runif(32)))
# Each sample has its own axis list, with one element (because this example is 1D)
axis_1D <- list(list(1:16), list(1:32))
my_1D_data <- new_nmr_dataset(metadata_1D, data_fields_1D, axis_1D)

# Example for 2D samples
metadata_2D <- list(external = data.frame(NMRExperiment = c("11", "21")))
data_fields_2D <- list(data_2rr = list(matrix(runif(16 * 3), nrow = 16, ncol = 3),
    runif(32 * 3),
    nrow = 32, ncol = 3
))
# Each sample has its own axis list, with one element (because this example is 1D)
axis_2D <- list(list(1:16, 1:3), list(1:32, 1:3))
my_2D_data <- new_nmr_dataset(metadata_2D, data_fields_2D, axis_2D)

}
\seealso{
Other class helper functions: 
\code{\link{format.nmr_dataset}()},
\code{\link{format.nmr_dataset_1D}()},
\code{\link{format.nmr_dataset_peak_table}()},
\code{\link{is.nmr_dataset_1D}()},
\code{\link{is.nmr_dataset_peak_table}()},
\code{\link{new_nmr_dataset_1D}()},
\code{\link{new_nmr_dataset_peak_table}()},
\code{\link{print.nmr_dataset}()},
\code{\link{print.nmr_dataset_1D}()},
\code{\link{print.nmr_dataset_peak_table}()},
\code{\link{validate_nmr_dataset}()},
\code{\link{validate_nmr_dataset_family}()},
\code{\link{validate_nmr_dataset_peak_table}()}
}
\concept{class helper functions}
