% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_baseline_threshold.R
\name{nmr_baseline_threshold_plot}
\alias{nmr_baseline_threshold_plot}
\title{Plot the baseline thresholds}
\usage{
nmr_baseline_threshold_plot(
  nmr_dataset,
  thresholds,
  NMRExperiment = "all",
  chemshift_range = c(9.5, 10),
  ...
)
}
\arguments{
\item{nmr_dataset}{An \link{nmr_dataset_1D} object}

\item{thresholds}{A named vector. The values are baseline thresholds. The names are NMRExperiments.}

\item{NMRExperiment}{The NMRExperiments to plot (Use \code{"all"} to plot all of them)}

\item{chemshift_range}{The range to plot, as a first check use the \code{range_without_peaks} from \link{nmr_baseline_threshold}}

\item{...}{arguments passed to \link[ggplot2:aes]{ggplot2::aes} (or to \link[ggplot2:aes_]{ggplot2::aes_string}, being deprecated).}
}
\value{
A plot.
}
\description{
If you have a lot of samples you can make the plot window bigger (or
use "\verb{ ```\{r fig.height=10, fig.width=10\}}" in notebooks), or choose some NMRExperiments.
}
\examples{

ppm_axis <- seq(from = 0, to = 10, length.out = 1000)
data_1r <- matrix(runif(1000, 0, 10), nrow = 1) + 100
dataset_1D <- new_nmr_dataset_1D(
    ppm_axis = ppm_axis,
    data_1r = data_1r,
    metadata = list(external=data.frame(NMRExperiment = "10"))
)
bl_threshold <- nmr_baseline_threshold(dataset_1D, range_without_peaks = c(9.5,10))
baselineThresh <- nmr_baseline_threshold(dataset_1D)
nmr_baseline_threshold_plot(dataset_1D, bl_threshold)
}
