% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batman_helpers.R
\name{nmr_batman}
\alias{nmr_batman}
\alias{nmr_batman_write_options}
\alias{nmr_batman_export_dataset}
\alias{nmr_batman_multi_data_user_hmdb}
\alias{nmr_batman_multi_data_user}
\alias{nmr_batman_metabolites_list}
\title{Batman helpers}
\usage{
nmr_batman_write_options(
  bopts,
  batman_dir = "BatmanInput",
  filename = "batmanOptions.txt"
)

nmr_batman_export_dataset(
  nmr_dataset,
  batman_dir = "BatmanInput",
  filename = "NMRdata.txt"
)

nmr_batman_multi_data_user_hmdb(
  batman_dir = "BatmanInput",
  filename = "multi_data_user.csv"
)

nmr_batman_multi_data_user(
  multiplet_table,
  batman_dir = "BatmanInput",
  filename = "multi_data_user.csv"
)

nmr_batman_metabolites_list(
  metabolite_names,
  batman_dir = "BatmanInput",
  filename = "metabolitesList.csv"
)
}
\arguments{
\item{bopts}{Batman options}

\item{batman_dir}{Batman input directorye}

\item{filename}{Filename to use, inside \code{batman_dir}}

\item{nmr_dataset}{An \link{nmr_dataset_1D} object}

\item{multiplet_table}{A data frame, like the \link{hmdb} dataset}

\item{metabolite_names}{A character vector of the metabolite names to consider}
}
\value{
These are helper functions to make Batman tests easier
}
\description{
Batman helpers
}
\examples{
bopts <- nmr_batman_options()
# nmr_batman_write_options(bopts)

dataset_1D <- nmr_dataset_load(system.file("extdata", "nmr_dataset.rds", package = "AlpsNMR"))
# nmr_batman_export_dataset(dataset_1D)

message("Use of multi_data_user_hmdb")
# multi_data_user_hmdb <- nmr_batman_multi_data_user_hmdb()
hmdb <- NULL
# utils::data("hmdb", package = "AlpsNMR", envir = environment())
# hmdb <- nmr_batman_multi_data_user(hmbd)

metabolite_names <- c("alanine", "glucose")
# metabolite_names <- nmr_batman_metabolites_list(metabolite_names)

}
\seealso{
Other batman functions: 
\code{\link{nmr_batman_options}()}
}
\concept{batman functions}
