% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{to_ChemoSpec}
\alias{to_ChemoSpec}
\title{Convert to ChemoSpec Spectra class}
\usage{
to_ChemoSpec(nmr_dataset, desc = "A nmr_dataset", group = NULL)
}
\arguments{
\item{nmr_dataset}{An \link{nmr_dataset_1D} object}

\item{desc}{a description for the dataset}

\item{group}{A string with the column name from the metadata that has grouping information}
}
\value{
A Spectra object from the ChemoSpec package
}
\description{
Convert to ChemoSpec Spectra class
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))
chemo_spectra <- to_ChemoSpec(dataset_1D)

}
\seealso{
Other import/export functions: 
\code{\link{Pipelines}},
\code{\link{files_to_rDolphin}()},
\code{\link{load_and_save_functions}},
\code{\link{nmr_data}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_read_bruker_fid}()},
\code{\link{nmr_read_samples}()},
\code{\link{nmr_zip_bruker_samples}()},
\code{\link{save_files_to_rDolphin}()},
\code{\link{save_profiling_output}()}
}
\concept{import/export functions}
