% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbundanceMetadata.R
\docType{class}
\name{AbundanceMetadata-class}
\alias{AbundanceMetadata-class}
\alias{AbundanceMetadata}
\title{AbundanceMetadata s4 class}
\description{
An S4 class that is the parent class of all abundance tool 
Classes. 
It contains information needed to all abundance tools.
This class can be seen as an abstract class, you should never instanciate 
it.
}
\section{Slots}{

\describe{
\item{\code{txOut}}{Similar to tximport txOut parameter. Allows to keep abundance at
transcript level if TRUE (default = FALSE)}

\item{\code{ignoreTxVersion}}{logical used to remove transcript version in 
transcript ID if TRUE (default = FALSE)}

\item{\code{cutoff_type}}{Defines the approach used to generate present/absent calls.
default value is 'pValue', allowing calls to be generated using a pValue.
Other possible values are 'intergenic' allowing to use a ratio of intergenic
sequences considered as present as a threshold, or use qValue allowing calls
to be generated from a qValue.}

\item{\code{cutoff}}{numeric value of the cutoff used to generate the present/absent
calls. If value of the slot cutoff_type is 'pValue' this cutoff will correspond
to the highest pValue allowing to define a gene as present. If value of the slot 
cutoff_type is 'intergenic' this cutoff will correspond to the proportion of 
intergenic present divided by proportion of protein coding present. 
If value of the slot cutoff_type is 'qValue' this cutoff will correspond to the
highest qValue allowing to define a gene as present. The qValue is calculated
based on the proportion of intergenic/(intergenic + genic) at each unique abundance value (TPM).
The default value is 0.05. Be careful when modifying this value as it could have a huge impact 
on present/absent calls.}

\item{\code{full_transcriptome_file}}{Name of the fasta file containing both 
transcriptomic and intergenic regions. This file is created by the pipeline.
You should edit this slot only if you already have such a file with a 
different name.}

\item{\code{tx2gene_file}}{Name of the file containing the mapping between 
transcript IDs and gene IDs (See the tximport package vignette for more 
details). This file is created by the pipeline. You should edit this 
slot only if you already have such a file with a different name. This 
file must be store at get_species_path()}

\item{\code{tx2gene_file_without_version}}{Name of the file containing the mapping 
between transcript IDs and gene IDs if ignoreTxVersion == TRUE (See the 
tximport package vignette for more details). This file is created by the 
pipeline. You should edit this slot only if you already have such a file 
with a different name. This file must be store at get_species_path()}

\item{\code{gene2biotype_file}}{Name of the file containing the mapping between 
gene IDs and biotypes. This file is created by the pipeline. You should 
edit this slot only if you already have such a file with a different name.}

\item{\code{tool_name}}{Name of the tool that will be use to generate transcript 
abundance estimation. All descendant of this class have to define a value 
for this slot (in the prototype section)}

\item{\code{abundance_file}}{Name of the transcript-level abundance file. All 
descendant of this class have to define a value for this slot (in the 
prototype section)}

\item{\code{read_size_kmer_threshold}}{read size of the library below which 
transcript index is created using a smaller kmer size}

\item{\code{transcript_id_header}}{Name of the header of the column that contains 
transcript ID}

\item{\code{count_header}}{Name of the header of the column that contains count}

\item{\code{abundance_header}}{Name of the header of the column that contains 
abundance}

\item{\code{eff_length_header}}{Name of the header of the column that contains 
effective length}

\item{\code{transcript_calls_file_name}}{default name of file containing all 
transcript ids and calls (if calls created at transcript level)}

\item{\code{gene_calls_file_name}}{default name of file containing all gene ids and 
calls (if calls created at gene level)}

\item{\code{transcript_cutoff_file_name}}{default name of file containing summary 
of cutoff used to generate transcript expression calls (if calls created 
at transcript level)}

\item{\code{gene_cutoff_file_name}}{default name of file containing summary of 
cutoff used to generate gene expression calls (if calls created at gene 
level)}

\item{\code{transcript_distribution_file_name}}{default name of density plot file 
containing TPM distribution of all transcripts  (if calls created at 
transcript level)}

\item{\code{gene_distribution_file_name}}{default name of density plot file 
containing TPM distribution of all genes (if calls created at gene level)}
}}

