% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kallisto.R
\name{run_kallisto}
\alias{run_kallisto}
\title{Run one kallisto abundance analyse}
\usage{
run_kallisto(
  myKallistoMetadata,
  myBgeeMetadata,
  myUserMetadata,
  transcriptome_path = ""
)
}
\arguments{
\item{myKallistoMetadata}{A Reference Class KallistoMetadata object.}

\item{myBgeeMetadata}{A Reference Class BgeeMetadata object.}

\item{myUserMetadata}{A Reference Class UserMetadata object. 
This object has to be edited before running kallisto @seealso 
UserMetadata.R}

\item{transcriptome_path}{path to the transcriptome fasta file. 
If no path is provided the default path created using BgeeCall
will be used. IMPORTANT : in BgeeCall the transcriptome used
to generate present/absent calls contains both intergenic sequences 
downloaded from Bgee and the reference transcriptome.}
}
\value{
create kallisto output files and save them on the hard drive
}
\description{
Run kallisto and all preliminary steps if needed like :
- creation of transcriptome with intergenic (if needed)
- installation of kallisto (if needed)
- index creation (if needed)
- run kallisto quantification
}
\examples{
\dontrun{
# first a transcriptome is needed. Here it is downloaded from AnnotationHub
library(AnnotationHub)
ah <- AnnotationHub()
ah_resources <- query(ah, c('Ensembl', 'Caenorhabditis elegans', '84'))

# kallisto can not deal with S4 objects. Path to transcriptome file is 
# required
transcriptome_object <- rtracklayer::import.2bit(ah_resources[['AH50453']])
transcriptome_path <- file.path(getwd(),'transcriptome.fa')
Biostrings::writeXStringSet(transcriptome_object, transcriptome_path)

# initialize objects needed to create destination folder
bgee <- new('BgeeMetadata')
user <- new('UserMetadata', species_id = '6239')
user <- setRNASeqLibPath(user, system.file( 
                     'extdata', 'SRX099901_subset', 
                     package = 'BgeeCall'))
kallisto <- new('KallistoMetadata')

# generate transcriptome index
run_kallisto(kallisto, bgee, user, transcriptome_path)
}

}
\author{
Julien Wollbrett.
}
