## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment  = "#>",
    fig.path = "figures/",
    fig.crop = FALSE,
    warning  = FALSE,
    message  = FALSE
)

## ----eval = FALSE-------------------------------------------------------------
# # Requires R >= 4.5.0
# if (!require("BiocManager", quietly = TRUE)) install.packages("BiocManager")
# BiocManager::install("BreastSubtypeR")

## ----eval = FALSE-------------------------------------------------------------
# citation("BreastSubtypeR")

## ----pkgs-and-data, message=FALSE---------------------------------------------
library(BreastSubtypeR)

# Example data
data("BreastSubtypeRobj")
data("OSLO2EMIT0obj")

## ----eval=TRUE----------------------------------------------------------------
# Pre-processing: automatically apply tailored normalisation, map probes/IDs to Entrez,
# and (optionally) impute missing values
data_input <- Mapping(
    OSLO2EMIT0obj$se_obj,
    method = "max", # mapping strategy (example)
    RawCounts = FALSE,
    impute = TRUE,
    verbose = FALSE
)

## ----eval=TRUE----------------------------------------------------------------
methods <- c("parker.original", "PCAPAM50", "sspbc")

res <- BS_Multi(
    data_input = data_input,
    methods = methods,
    Subtype = FALSE,
    hasClinical = FALSE
)

# Per-sample calls (methods × samples)
head(res$res_subtypes, 5)


## ----eval=TRUE----------------------------------------------------------------
res_auto <- BS_Multi(
    data_input = data_input,
    methods = "AUTO",
    Subtype = FALSE,
    hasClinical = FALSE
)

# Visualise multi-method output and concordance
Vis_Multi(res_auto$res_subtypes)

## ----eval=TRUE----------------------------------------------------------------
res_pam <- BS_parker(
    se_obj = data_input$se_NC, # object prepared for NC-based methods
    calibration = "Internal",
    internal = "medianCtr",
    Subtype = FALSE,
    hasClinical = FALSE
)

## ----eval=TRUE----------------------------------------------------------------
res_aims <- BS_AIMS(data_input$se_SSP)

## ----eval = FALSE-------------------------------------------------------------
# BreastSubtypeR::iBreastSubtypeR() # interactive GUI (local)

## ----eval = FALSE-------------------------------------------------------------
# install.packages(c("shiny", "bslib"))

## -----------------------------------------------------------------------------
sessionInfo()

