% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctcbn.R
\name{ctcbn}
\alias{ctcbn}
\title{CT-CBN}
\usage{
ctcbn(
  datasets,
  bootstrapSamples = 0,
  randomSeed = 1,
  samplingRate = 1,
  epsilon = 2,
  numDrawnSamples = 0,
  numEmRuns = 1,
  nCores = 1
)
}
\arguments{
\item{datasets}{Vector of \code{Spock} objects with poset and pattern/lambda data or a \code{Spock} object (alias of ctcbnSingle).}

\item{bootstrapSamples}{Number of bootstrap samples (requires \code{epsilon} > 0, \code{numDrawnSamples} = 0)}

\item{randomSeed}{Random seed.}

\item{samplingRate}{Sampling rate.}

\item{epsilon}{If between 0 and 1, the fraction of violations allowed per edge. If negative, the interval 0 to 0.5 will be sampled equidistantly with N points and the output \code{Spock} will include multiple resulting posets.}

\item{numDrawnSamples}{If > 0, the number of samples to draw from the model. If zero (default), the model will be learned from data.}

\item{numEmRuns}{Number of em runs.}

\item{nCores}{Maximum number of threads to use to parallelize.}
}
\value{
A matrix of results.
}
\description{
CT-CBN
}
\examples{
examplePath <- getExamples()[3]
bc <- Spock$new(
    poset = readPoset(examplePath)$sets,
    numMutations = readPoset(examplePath)$mutations,
    genotypeMatrix = readPattern(examplePath)
)
ctcbn(bc)
ctcbn(c(bc, bc, bc))
}
