% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{find_modules}
\alias{find_modules}
\alias{find_modules,CEMiTool-method}
\title{Co-expression modules definition}
\usage{
find_modules(cem, ...)

\S4method{find_modules}{CEMiTool}(
  cem,
  cor_method = c("pearson", "spearman"),
  cor_function = "cor",
  eps = 0.1,
  set_beta = NULL,
  force_beta = FALSE,
  min_ngen = 20,
  merge_similar = TRUE,
  network_type = "unsigned",
  tom_type = "signed",
  diss_thresh = 0.8,
  verbose = FALSE
)
}
\arguments{
\item{cem}{Object of class \code{CEMiTool}.}

\item{...}{Optional parameters.}

\item{cor_method}{A character string indicating which correlation coefficient
is to be computed. Default \code{"pearson"}}

\item{cor_function}{A character string indicating the correlation function to be used. Default \code{'cor'}.}

\item{eps}{A value for accepted R-squared interval between subsequent beta values. Default is 0.1.}

\item{set_beta}{A value to override the automatically selected beta value. Default is NULL.}

\item{force_beta}{Whether or not to automatically force a beta value based on number of samples. Default is FALSE.}

\item{min_ngen}{Minimal number of genes per submodule. Default \code{20}.}

\item{merge_similar}{Logical. If \code{TRUE}, (the default) merge similar modules.}

\item{network_type}{A character string indicating to use either "unsigned" (default) or "signed" networks. Default \code{"unsigned"}}

\item{tom_type}{A character string indicating to use either "unsigned" or "signed" (default) TOM similarity measure.}

\item{diss_thresh}{Module merging correlation threshold for eigengene similarity.
Default \code{0.8}.}

\item{verbose}{Logical. If \code{TRUE}, reports analysis steps. Default \code{FALSE}}
}
\value{
Object of class \code{CEMiTool}
}
\description{
Defines co-expression modules
}
\examples{
# Get example expression data
data(expr0)
# Initialize CEMiTool object with expression
cem <- new_cem(expr0, filter=TRUE, apply_vst=FALSE)
# Define network modules
cem <- find_modules(cem)
# Check results
head(module_genes(cem))

}
