% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGeometricClustering.R
\name{getObjectSubsetClusteringStatistics}
\alias{getObjectSubsetClusteringStatistics}
\title{This function computes statistics for the geometric
clustering of a gene set (in UMAP or PCA reduction)
based on the median distance from its complement to
the set.}
\usage{
getObjectSubsetClusteringStatistics(
  fPrime,
  geneSubset,
  numTrials = 1000,
  reduction = "UMAP",
  numPCs = 10
)
}
\arguments{
\item{fPrime}{\itemize{
\item a transposed Seurat object, i.e. a
Seurat object of genes or SingleCellExperiment to
be converted to a Seurat object
}}

\item{geneSubset}{\itemize{
\item a subset of the genes which can
be given as a character vector or as a logical vector
}}

\item{numTrials}{\itemize{
\item the number of random trials to be
carried out for randomised testing. Defaults to 1000.
}}

\item{reduction}{\itemize{
\item can be 'UMAP' or 'PCA', defaults
to 'UMAP'
}}

\item{numPCs}{\itemize{
\item number of PCs to use if reduction is
'PCA'
}}
}
\value{
A list of statistics resulting from the
testing of randomised subsets of the same size as the
given gene subset.  These include subsetDistance, the
actual median complement distance; randomSubsetDistance,
the median complement distances for randomised subsets;
pValue, computed by comparing the real and randomised
distances; and zScore, the z-distance of the actual
median distance from the mean of the randomised distances.
}
\description{
This function computes statistics for the geometric
clustering of a gene set (in UMAP or PCA reduction)
based on the median distance from its complement to
the set.
}
\examples{
getExample = make.getExample()
STranspose = getExample('STranspose',toy=TRUE)
hallmark = getExample('hallmark')
geneSubset = intersect(colnames(STranspose),hallmark[["HALLMARK_TNFA_SIGNALING_VIA_NFKB"]])
stats = getObjectSubsetClusteringStatistics(STranspose,geneSubset,100)
}
