% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleGenesVsCells.R
\name{meanZPerCluster}
\alias{meanZPerCluster}
\title{This finds the mean z-score for features in subsets
of cells e.g., in each of the seurat_clusters}
\usage{
meanZPerCluster(f, features, clusterBy = "seurat_clusters", layer = "data")
}
\arguments{
\item{f}{\itemize{
\item a Seurat object of cells or SingleCellExperiment to
be converted to a Seurat object
}}

\item{features}{\itemize{
\item a set of features of f
}}

\item{clusterBy}{\itemize{
\item the name of the column of f@meta.data to
be used to subset the cells
}}

\item{layer}{\itemize{
\item the data layer to be used for z-scores
}}
}
\value{
This returns a data frame each of whose columns
corresponds to a value of the clusterBy data.  In the case
where the clusterBy data is a factor or numeric, it prepends
cluster_ to the column name.
}
\description{
This finds the mean z-score for features in subsets
of cells e.g., in each of the seurat_clusters
}
\examples{
getExample = make.getExample()
exSeuratObj = getExample('exSeuratObj',toy=TRUE)
STranspose = getExample('STranspose',toy=TRUE)
df = meanZPerCluster(exSeuratObj,features=colnames(STranspose),
                     clusterBy='shortName')
}
