% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Replicates.R
\name{joinReplicates}
\alias{joinReplicates}
\title{Joins together two GRange objects in a single containing all the
replicates}
\usage{
joinReplicates(methylationData1, methylationData2, usecomplete = FALSE)
}
\arguments{
\item{methylationData1}{the methylation data stored as a \code{\link[GenomicRanges]{GRanges}}
object with four metadata columns (see \code{\link{methylationDataList}}).}

\item{methylationData2}{the methylation data stored as a \code{\link[GenomicRanges]{GRanges}}
object with four metadata columns (see \code{\link{methylationDataList}}).}

\item{usecomplete}{Boolean, determine wheter, when the two dataset differ for
number of cytosines, if the smaller dataset should be added with zero reads
to match the bigger dataset.}
}
\value{
returns a \code{\link[GenomicRanges]{GRanges}} object containing multiple metadata
columns with the reads from each object passed as parameter
}
\description{
This function joins together data that come from biological replicates to
perform analysis
}
\examples{


# load the methylation data
data(methylationDataList)

# Joins the wildtype and the mutant in a single object
joined_data <- joinReplicates(methylationDataList[["WT"]],
                              methylationDataList[["met1-3"]], FALSE)


}
\author{
Alessandro Pio Greco and Nicolae Radu Zabet
}
