% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DMRcaller.R
\docType{data}
\name{ontSampleGRangesList}
\alias{ontSampleGRangesList}
\title{The ONT methylation data list}
\format{
The \code{GRanges} elements contain six metadata columns
\describe{
 \item{context}{the context in which the DMRs are computed \code{"CG"}.}
 \item{trinucleotide_context}{the specific context of the cytosine (H is
                             replaced by the actual nucleotide).}
 \item{ONT_Cm}{comma-delimited read‐indices called modified}
 \item{ONT_C}{comma-delimited read‐indices covering but unmodified}
 \item{readsM}{the number of methylated reads.}
 \item{readsN}{the total number of reads.}
}
}
\source{
Each element was created by calling \code{bam} files with \code{\link{readONTbam}}
function which in \code{\link{DMRcaller}} package.
The sample pod5 files were from the nanopore dataset from 1000 genome project
\url{https://pmc.ncbi.nlm.nih.gov/articles/PMC10942501/}.
\url{https://s3.amazonaws.com/1000g-ont/index.html?prefix=pod5_data/GM18501_R9/}
\code{.pod5} files in the case of GM18501 and
\url{https://s3.amazonaws.com/1000g-ont/index.html?prefix=pod5_data/GM18876_R9/}
\code{.pod5} files in the case of GM18876 cell line.
For base-calling and alignment, run \code{dorado, ver.0.9.6}
\url{https://github.com/nanoporetech/dorado?tab=readme-ov-file#dna-models}
to generate the \code{bam} files with \code{dna_r10.4.1_e8.2_400bps_hac@v5.2.0} as basecalling model.
}
\description{
A \code{GRangesList} object containing the methylation data at each cytosine
location in the genome in  GM18501 and  GM18876 B-Lymphocyte cell lines in
Homo sapiens. The data only contains the 1.5 ~ 2 Mbp from Chromosome 1.
}
