% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ONTdata.R
\name{selectCytosine}
\alias{selectCytosine}
\title{Select Cytosine Positions}
\usage{
selectCytosine(
  genome = BSgenome.Hsapiens.UCSC.hg38,
  context = c("CG", "CHG", "CHH"),
  chr = NULL,
  region = NULL
)
}
\arguments{
\item{genome}{A \code{BSgenome} object or the name (character) of a BSgenome package
to use as the reference genome. If a package name is given, it will be loaded
automatically (default: \code{BSgenome.Hsapiens.UCSC.hg38}).
\strong{Note:} When running on an HPC system, please ensure that the required
\code{BSgenome} package is already installed and loaded in advance.}

\item{context}{A character vector of one or more methylation contexts to include:
\code{"CG"}, \code{"CHG"}, and/or \code{"CHH"}.  Defaults to all three.}

\item{chr}{An optional character vector of chromosome names to restrict the
enumeration.  If \code{NULL}, all sequences in \code{genome} are used.}

\item{region}{An optional \code{\link[GenomicRanges]{GRanges}} object specifying
subregions to keep.  Requires \code{chr} to be non-\code{NULL}.}
}
\value{
A \code{\link[GenomicRanges]{GRanges}} object with one 1-bp range per
cytosine, and two metadata columns:
\describe{
  \item{context}{A factor indicating the context (\code{"CG"},
    \code{"CHG"}, or \code{"CHH"}).}
  \item{trinucleotide_context}{Character or factor giving the
    surrounding trinucleotide sequence (or \code{NA} for \code{"CG"}).}
}
}
\description{
Constructs a \code{\link[GenomicRanges]{GRanges}} of all cytosine positions
in the specified BSgenome (or BSgenome package name), optionally filtering
by methylation context (\code{"CG"}, \code{"CHG"}, \code{"CHH"}), by
chromosome, and by genomic region.
}
\details{
This function enumerate cytosine positions in a BSgenome reference
}
\examples{
\dontrun{
library(BSgenome.Hsapiens.UCSC.hg38)

# Only CpG sites on chr1 and chr2:
gr_chr1_2 <- selectCytosine(context="CG", chr=c("chr1","chr2"))

# CHH sites in a specific region on chr3:
my_region <- GRanges("chr3", IRanges(1e6, 1e6 + 1e5))
gr_region <- selectCytosine(context="CHH", chr="chr3", region=my_region)
}

}
\seealso{
\code{\link{readONTbam}}, \code{\link{ontSampleGRangesList}}
}
\author{
Nicolae Radu Zabet and Young Jun Kim
}
