% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degree_network.R
\name{degree_network}
\alias{degree_network}
\title{Analyze and Visualize a Microbial Network}
\usage{
degree_network(
  graph_path,
  save_metrics = TRUE,
  metrics_path = "Global_Network_Metrics.csv",
  layout_type = "stress"
)
}
\arguments{
\item{graph_path}{Character or igraph object. Path to the GraphML file or an already loaded \code{igraph} object.}

\item{save_metrics}{Logical. If TRUE, saves the global metrics as a CSV file.}

\item{metrics_path}{Optional. Path to save the metrics file. Default: "Global_Network_Metrics.csv".}

\item{layout_type}{Character. Layout algorithm: "stress" (default), "graphopt", "fr", "mds", or "kk".}
}
\value{
A list containing:
\item{plot}{A ggplot object displaying the network.}
\item{metrics}{A dataframe with global network metrics.}
\item{layout_data}{The layout used for plotting.}
\item{graph}{The annotated igraph object.}
}
\description{
This function loads a microbial network from a GraphML file or an \code{igraph} object,
computes node degree and modularity, assigns node sizes based on degree, and visualizes the network.
Edge thickness is determined by weight. It also computes and optionally saves global network metrics.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  Complete <- load_graphml(system.file("extdata", "Complete.graphml", package = "DspikeIn"))

  # Save metrics to a temporary file
  temp_metrics <- file.path(tempdir(), "Global_Network_Metrics.csv")

  result <- degree_network(
    graph_path = Complete,
    save_metrics = TRUE,
    metrics_path = temp_metrics
  )

  print(result$metrics)
  print(result$plot)

  # Clean up temporary file
  unlink(temp_metrics)
}

}
