% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization_set.R
\name{norm.DESeq}
\alias{norm.DESeq}
\title{DESeq Normalization with Pseudocount and Integer Conversion}
\usage{
norm.DESeq(obj, groups, pseudocount = 1)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object.}

\item{groups}{A string specifying the grouping variable in sample data.}

\item{pseudocount}{A numeric value added to avoid zeros in the dataset.}
}
\value{
A list containing the normalized object (same format as input) and scaling factors.
}
\description{
DESeq Normalization
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  data("physeq_16SOTU", package = "DspikeIn")

  # Example 1: phyloseq input (subset to Animal.type == "Frog")
  physeq_frog <- phyloseq::subset_samples(physeq_16SOTU, Animal.type == "Frog")
  result_DESeq_phy <- norm.DESeq(physeq_frog, groups = "Animal.type", pseudocount = 1)

  # Example 2: TSE input (convert and subset to Animal.type == "Frog")
  tse_16SOTU <- convert_phyloseq_to_tse(physeq_16SOTU)
  col_meta <- SummarizedExperiment::colData(tse_16SOTU)
  tse_frog <- tse_16SOTU[, which(col_meta$Animal.type == "Frog")]
  result_DESeq_tse <- norm.DESeq(tse_frog, groups = "Animal.type", pseudocount = 1)
}
}
