#' check_full_results
#' 
#' Check full results generated by \link[EWCE]{bootstrap_enrichment_test}.
#' 
#' @inheritParams bootstrap_enrichment_test
#' @inheritParams generate_bootstrap_plots
#' @return Null output.
#' 
#' @keywords internal
check_full_results <- function(full_results,
                               sct_data) {
    if (!is.null(full_results)) {
        err_msg <- paste0(
            "ERROR: full_results must be a list of length 3 or 4",
            "(not",length(full_results),")", 
            "to be considered a valid output from bootstrap_enrichment_test."
        )
        if (!length(full_results) %in% c(3,4)) {
            stop(err_msg)
        }
        err_msg2 <- paste0(
            "ERROR: No cell types in full_results are found in",
            " sct_data. Perhaps the wrong annotLevel was used?"
        )
        if (sum(!as.character(unique(full_results$results$CellType)) %in%
            colnames(sct_data[[1]]$specificity)) ==
            length(as.character(unique(full_results$results$CellType)))) {
            stop(err_msg2)
        }
        if (sum(!as.character(unique(full_results$results$CellType)) %in%
            colnames(sct_data[[1]]$specificity)) > 0) {
            stop(err_msg2)
        }
    }
}
