#' Report cell type enrichment results
#'
#' Report cell type enrichment results generated by
#' \link[EWCE]{bootstrap_enrichment_test}.
#'
#' @returns NULL output.
#'
#' @keywords internal
#' @importFrom utils capture.output
report_results <- function(results,
                           sig_thresh = 0.05,
                           verbose = TRUE) {
    p <- q <- NULL

    #### Identify significant results ####
    if ("q" %in% colnames(results)) {
        sig_results <- subset(results, q < sig_thresh)
        messager(nrow(sig_results),
            "significant cell type enrichment results @",
            paste0("q<", sig_thresh, " :"), "\n",
            v = verbose
        )
    } else {
        sig_results <- subset(results, p < sig_thresh)
        messager(nrow(sig_results),
            "significant cell type enrichment results @",
            paste0("p<", sig_thresh, " :"), "\n",
            v = verbose
        )
    }
    #### Print significant results table ####
    rownames(sig_results) <- NULL
    if (nrow(sig_results) > 0) {
        messager(paste0(
            utils::capture.output(sig_results),
            collapse = "\n"
        ),
        v = verbose
        )
    }
}
