% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_background_multilist.R
\name{create_background_multilist}
\alias{create_background_multilist}
\title{Create background gene list for multiple species}
\usage{
create_background_multilist(
  gene_list1,
  gene_list2,
  gene_list1_species,
  gene_list2_species,
  output_species = "human",
  bg = NULL,
  use_intersect = FALSE,
  method = "homologene",
  verbose = TRUE
)
}
\arguments{
\item{output_species}{Species to convert all genes from 
\code{species1} and \code{species2} to first.
 \code{Default="human"}, but can be to either any species
  supported by \pkg{orthogene}, including 
 \code{species1} or \code{species2}.}

\item{bg}{User supplied background list that will be returned to the 
user after removing duplicate genes.}

\item{use_intersect}{When \code{species1} and \code{species2} are both
different from \code{output_species}, this argument will determine whether 
to use the intersect (\code{TRUE}) or union (\code{FALSE}) of all genes
from \code{species1} and \code{species2}.}

\item{method}{R package to use for gene mapping:
\describe{
 \item{\code{"gprofiler"}}{Slower but more species and genes.}
 \item{\code{"homologene"}}{Faster but fewer species and genes.}
 \item{\code{"babelgene"}}{Faster but fewer species and genes.
 Also gives consensus scores for each gene mapping based on a
 several different data sources.}
}}

\item{verbose}{Print messages.}
}
\value{
Background and gene list.
}
\description{
Create background gene list for the
intersection/union between multiple species
 (\code{gene_list1_species}, \code{gene_list2_species}, and
 \code{sctSpecies}), and then filter the gene lists to only include genes
 within the background.
}
\keyword{internal}
