% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_uninformative_genes.r
\name{drop_uninformative_genes}
\alias{drop_uninformative_genes}
\title{Drop uninformative genes}
\usage{
drop_uninformative_genes(
  exp,
  level2annot,
  mtc_method = "BH",
  adj_pval_thresh = 1e-05,
  convert_orths = FALSE,
  input_species = NULL,
  output_species = "human",
  non121_strategy = "drop_both_species",
  method = "homologene",
  as_sparse = TRUE,
  as_DelayedArray = FALSE,
  return_sce = FALSE,
  no_cores = 1,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{exp}{Expression matrix with gene names as rownames.}

\item{level2annot}{Array of cell types, with each sequentially corresponding
a column in the expression matrix.}

\item{mtc_method}{Multiple-testing correction method used by DGE step.
See \link[stats]{p.adjust} for more details.}

\item{adj_pval_thresh}{Minimum differential expression significance
that a gene must demonstrate across \code{level2annot} (i.e. cell types).}

\item{convert_orths}{If \code{input_species!=output_species} and
\code{convert_orths=TRUE}, will drop genes without
1:1 \code{output_species} orthologs and then convert \code{exp} gene names
to those of \code{output_species}.}

\item{input_species}{Which species the gene names in \code{exp} come from.
See \link[EWCE]{list_species} for all available species.}

\item{output_species}{Which species' genes names to convert \code{exp} to.
See \link[EWCE]{list_species} for all available species.}

\item{non121_strategy}{How to handle genes that don't have
1:1 mappings between \code{input_species}:\code{output_species}.
Options include:\cr
\describe{
\item{\code{"drop_both_species" or "dbs" or 1}}{
Drop genes that have duplicate
mappings in either the \code{input_species} or \code{output_species}
(\emph{DEFAULT}).}
\item{\code{"drop_input_species" or "dis" or 2}}{
Only drop genes that have duplicate
mappings in the \code{input_species}.}
\item{\code{"drop_output_species" or "dos" or 3}}{
Only drop genes that have duplicate
mappings in the \code{output_species}.}
\item{\code{"keep_both_species" or "kbs" or 4}}{
Keep all genes regardless of whether
they have duplicate mappings in either species.}
\item{\code{"keep_popular" or "kp" or 5}}{
Return only the most "popular" interspecies ortholog mappings.
 This procedure tends to yield a greater number of returned genes
 but at the cost of many of them not being true biological 1:1 orthologs.}
 \item{\code{"sum","mean","median","min" or "max"}}{
 When \code{gene_df} is a matrix and \code{gene_output="rownames"},
  these options will aggregate many-to-one gene mappings
  (\code{input_species}-to-\code{output_species})
  after dropping any duplicate genes in the \code{output_species}.
 }
}}

\item{method}{R package to use for gene mapping:
\describe{
 \item{\code{"gprofiler"}}{Slower but more species and genes.}
 \item{\code{"homologene"}}{Faster but fewer species and genes.}
 \item{\code{"babelgene"}}{Faster but fewer species and genes.
 Also gives consensus scores for each gene mapping based on a
 several different data sources.}
}}

\item{as_sparse}{Convert \code{exp} to sparse matrix.}

\item{as_DelayedArray}{Convert \code{exp} to \code{DelayedArray}
for scalable processing.}

\item{return_sce}{Whether to return the filtered results
as an expression matrix or a \pkg{SingleCellExperiment}.}

\item{no_cores}{Number of cores to parallelise across.
Set to \code{NULL} to automatically optimise.}

\item{verbose}{Print messages.
#' @inheritParams orthogene::convert_orthologs}

\item{...}{
  Arguments passed on to \code{\link[orthogene:convert_orthologs]{orthogene::convert_orthologs}}
  \describe{
    \item{\code{gene_df}}{Data object containing the genes
(see \code{gene_input} for options on how
the genes can be stored within the object).\cr
Can be one of the following formats:\cr
\describe{
\item{\code{matrix}}{A sparse or dense matrix.}
\item{\code{data.frame}}{A \code{data.frame},
 \code{data.table}. or \code{tibble}.}
\item{\code{list}}{A \code{list} or character \code{vector}.}
}
Genes, transcripts, proteins, SNPs, or genomic ranges
 can be provided in any format
(HGNC, Ensembl, RefSeq, UniProt, etc.) and will be
automatically converted to gene symbols unless
specified otherwise with the \code{...} arguments.\cr
\emph{Note}: If you set \code{method="homologene"}, you
must either supply genes in gene symbol format (e.g. "Sox2")
 OR set \code{standardise_genes=TRUE}.}
    \item{\code{gene_input}}{Which aspect of \code{gene_df} to
get gene names from:\cr
\describe{
\item{\code{"rownames"}}{From row names of data.frame/matrix.}
\item{\code{"colnames"}}{From column names of data.frame/matrix.}
\item{\code{<column name>}}{From a column in \code{gene_df},
 e.g. \code{"gene_names"}.}
}}
    \item{\code{gene_output}}{How to return genes.
Options include:\cr
\describe{
\item{\code{"rownames"}}{As row names of \code{gene_df}.}
\item{\code{"colnames"}}{As column names of \code{gene_df}.}
\item{\code{"columns"}}{As new columns "input_gene", "ortholog_gene"
(and "input_gene_standard" if \code{standardise_genes=TRUE})
in \code{gene_df}.}
\item{\code{"dict"}}{As a dictionary (named list) where the names
are input_gene and the values are ortholog_gene.}
\item{\code{"dict_rev"}}{As a reversed dictionary (named list)
where the names are ortholog_gene and the values are input_gene.}
}}
    \item{\code{standardise_genes}}{If \code{TRUE} AND
\code{gene_output="columns"}, a new column "input_gene_standard"
will be added to \code{gene_df} containing standardised HGNC symbols
identified by \link[gprofiler2]{gorth}.}
    \item{\code{drop_nonorths}}{Drop genes that don't have an ortholog
in the \code{output_species}.}
    \item{\code{agg_fun}}{Aggregation function passed to 
 \link[orthogene]{aggregate_mapped_genes}. 
Set to \code{NULL} to skip aggregation step (default).}
    \item{\code{mthreshold}}{Maximum number of ortholog names per gene to show.
Passed to \link[gprofiler2]{gorth}.
Only used when \code{method="gprofiler"} (\emph{DEFAULT : }\code{Inf}).}
    \item{\code{sort_rows}}{Sort \code{gene_df} rows alphanumerically.}
    \item{\code{gene_map}}{A \link[base]{data.frame} that maps the current gene names
to new gene names. 
This function's behaviour will adapt to different situations as follows: 
\describe{
\item{\code{gene_map=<data.frame>}}{When a data.frame containing the
gene key:value columns 
(specified by \code{input_col} and \code{output_col}, respectively)
is provided, this will be used to perform aggregation/expansion.}
\item{\code{gene_map=NULL} and \code{input_species!=output_species}}{
A \code{gene_map} is automatically generated by
 \link[orthogene]{map_orthologs} to perform inter-species 
 gene aggregation/expansion.}
\item{\code{gene_map=NULL} and \code{input_species==output_species}}{
A \code{gene_map} is automatically generated by
 \link[orthogene]{map_genes} to perform within-species 
 gene gene symbol standardization and aggregation/expansion.}
}}
    \item{\code{input_col}}{Column name within \code{gene_map} with gene names matching 
the row names of \code{X}.}
    \item{\code{output_col}}{Column name within \code{gene_map} with gene names
that you wish you map the row names of \code{X} onto.}
  }}
}
\value{
exp Expression matrix with gene names as row names.
}
\description{
\code{drop_uninformative_genes} drops uninformative genes in order to reduce
compute time and noise in subsequent steps. It achieves this through several
steps, each of which are optional:
\itemize{
\item{Drop non-1:1 orthologs:\cr}{Removes genes that don't have 1:1 orthologs
with the \code{output_species} ("human" by default).}
\item{Drop non-varying genes:\cr}{Removes genes that don't vary across cells
based on variance deciles.}
\item{Drop non-differentially expressed genes (DEGs):\cr}{
Removes genes that are not significantly differentially
expressed across cell-types (multiple DEG methods available).}
}
}
\examples{
cortex_mrna <- ewceData::cortex_mrna()
# Use only a subset of genes to keep the example quick
cortex_mrna$exp <- cortex_mrna$exp[1:300, ]

## Convert orthologs at the same time
exp2_orth <- drop_uninformative_genes(
    exp = cortex_mrna$exp,
    level2annot = cortex_mrna$annot$level2class,
    input_species = "mouse"
)
}
