% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_genes_without_1to1_homolog.r
\name{filter_genes_without_1to1_homolog}
\alias{filter_genes_without_1to1_homolog}
\title{filter_genes_without_1to1_homolog}
\usage{
filter_genes_without_1to1_homolog(
  filenames,
  input_species = "mouse",
  convert_nonhuman_genes = TRUE,
  annot_levels = NULL,
  suffix = "_orthologs",
  verbose = TRUE
)
}
\arguments{
\item{filenames}{List of file names for sct_data saved as \emph{.rda} files.}

\item{input_species}{Which species the gene names in \code{exp} come from.}

\item{convert_nonhuman_genes}{Whether to convert the \code{exp}
row names to human gene names.}

\item{annot_levels}{[Optional] Names of each annotation level.}

\item{suffix}{Suffix to add to the file name (right before \emph{.rda}).}

\item{verbose}{Print messages.}
}
\value{
List of the filtered CellTypeData file names.
}
\description{
Deprecated function. Please use \link[EWCE]{filter_nonorthologs} instead.
}
\details{
\bold{Note:} This function replaces the original
 \code{filter_genes_without_1to1_homolog} function.
\code{filter_genes_without_1to1_homolog} is
now a wrapper for \code{filter_nonorthologs}.
}
\examples{
# Load the single cell data
ctd <- ewceData::ctd()
tmp <- tempfile()
save(ctd, file = tmp)
fNames_ALLCELLS_orths <- EWCE::filter_nonorthologs(filenames = tmp)
}
