% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotatePC.R
\name{annotatePC}
\alias{annotatePC}
\title{Annotate top PCs from the dataset}
\usage{
annotatePC(
  PCnum,
  val_all,
  RAVmodel,
  n = 5,
  scoreCutoff = 0.5,
  nesCutoff = NULL,
  simplify = TRUE,
  abs = FALSE,
  trimed_pathway_len = 45
)
}
\arguments{
\item{PCnum}{A numeric vector. PC number of your dataset to retrieve
annotation results for. The vector can contain any integer number among
\code{1:8}.}

\item{val_all}{The output from \code{\link{validate}}}

\item{RAVmodel}{The RAVmodel used to generate the input for the argument,
\code{val_all}.}

\item{n}{An integer. Default is 5. The number of the top enriched pathways
to print out. If there are fewer than n pathways passed the cutoff, it will
print out \code{NA}.}

\item{scoreCutoff}{A numeric value for the minimum correlation between loadings
of the dataset principal component and the RAV. Default is 0.5.}

\item{nesCutoff}{A numeric value for the minimum Normalized Enrichment Score
(NES) for the enrichment analysis. Default is \code{NULL}
The suggested value is 3.}

\item{simplify}{A logical. Under default (\code{TRUE}), the output will be a
data frame with the number of column same as the length of \code{PCnum}
argument, and the number of row same as the \code{n} argument. If it is set
to \code{FALSE}, the output will be a list with the length of \code{PCnum}
argument, where each element is a data frame containing detailed GSEA output
of enriched pathways.}

\item{abs}{Default is \code{FALSE}. If it's set to \code{TRUE}, the enriched
pathways will be listed based on absolute value of the Normalized Enrichment
Score (NES).}

\item{trimed_pathway_len}{Positive integer values, which is the display width
of pathway names. Default is 45.}
}
\value{
A data frame of a list based on the \code{simplify} argument. Check
the output detail above.
}
\description{
This function finds the RAV with the highest validation score (including
RAVs with negative silhouette width) for specified PC of the dataset and
returns the top enriched pathways.
}
\examples{
data(miniRAVmodel)
library(bcellViper)
data(bcellViper)
val_all <- validate(dset, miniRAVmodel)
annotatePC(2, val_all, miniRAVmodel)

}
