% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateRAV.R
\name{annotateRAV}
\alias{annotateRAV}
\title{Search the top enriched pathways for RAV}
\usage{
annotateRAV(RAVmodel, ind, n = 5, abs = FALSE)
}
\arguments{
\item{RAVmodel}{PCAGenomicSignatures object.}

\item{ind}{An integer for RAV you want to check the enriched pathways.}

\item{n}{A number of top enriched pathways to output. Default is 5.}

\item{abs}{Default is \code{FALSE}. If it's set to \code{TRUE}, the enriched
pathways will be listed based on \code{abs(NES)}.}
}
\value{
A data frame with \code{n} rows and 4 columns;
Description, NES, pvalue, and qvalues
}
\description{
Search the top enriched pathways for RAV
}
\examples{
data(miniRAVmodel)
annotateRAV(miniRAVmodel, ind = 695)

}
