% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZlmFit.R
\name{summary,ZlmFit-method}
\alias{summary,ZlmFit-method}
\alias{"summary-ZlmFit",}
\alias{"ZlmFit-summary",}
\alias{"summary.ZlmFit"}
\title{Summarize model features from a \code{ZlmFit} object}
\usage{
\S4method{summary}{ZlmFit}(
  object,
  logFC = TRUE,
  doLRT = FALSE,
  level = 0.95,
  parallel = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{ZlmFit} object}

\item{logFC}{If TRUE, calculate log-fold changes, or output from a call to \code{getLogFC}.}

\item{doLRT}{if TRUE, calculate lrTests on each coefficient, or a character vector of such coefficients to consider.}

\item{level}{what level of confidence coefficient to return.  Defaults to 95 percent.}

\item{parallel}{If TRUE and \code{option(mc.cores)>1} then multiple cores will be used in fitting.}

\item{...}{ignored}
}
\value{
\code{data.table}
}
\description{
Returns a \code{data.table} with a special print method that shows the top 2 most significant genes by contrast.
This \code{data.table} contains columns: 
\describe{
  \item{primerid}{the gene}
  \item{component}{C=continuous, D=discrete, logFC=log fold change, S=combined using Stouffer's method, H=combined using hurdle method}
\item{contrast}{the coefficient/contrast of interest}
\item{ci.hi}{upper bound of confidence interval}
\item{ci.lo}{lower bound of confidence interval}
\item{coef}{point estimate}
\item{z}{z score (coefficient divided by standard error of coefficient)}
\item{Pr(>Chisq)}{likelihood ratio test p-value (only if \code{doLRT=TRUE})}
}
Some of these columns will contain NAs if they are not applicable for a particular component or contrast.
}
\examples{
data(vbetaFA)
z <- zlm(~Stim.Condition, vbetaFA[1:5,])
zs <- summary(z)
names(zs)
print(zs)
##Select `datatable` copmonent to get normal print method
zs$datatable
## Can use parallel processing for LRT now
summary(z, doLRT = TRUE, parallel = TRUE)
}
\seealso{
print.summaryZlmFit
}
