% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runPrd.R
\name{runPrd}
\alias{runPrd}
\title{Run PARADIGM on multi-omic data}
\usage{
runPrd(real_se, fpth, outdir, PARADIGM_bin=NULL, nohup_bin=NULL,
    sampleids=NULL, file_tag=NULL, threads=1)
}
\arguments{
\item{real_se}{A SummarizedExperiment object of PARADIGM CNA and RNA states.
It is the same matrix as the output from \code{ppRealInp()}.}

\item{fpth}{Name of a pathway file for PARADIGM.}

\item{outdir}{Output folder to save all results.}

\item{PARADIGM_bin}{PARADIGM binary, which can be downloaded from
https://github.com/sng87/paradigm-scripts/tree/master/public/exe. Note that
the binary is only available for Linux or MacOS. Default: NULL}

\item{nohup_bin}{nohup binary, which is used for long running PARADIGM jobs.
Default: NULL}

\item{sampleids}{A vector of sample IDs to run PARADIGM on. If not provided,
all the samples that exist in both copy-number alteration
and RNA files will be ran. Default: NULL}

\item{file_tag}{A string of output file name tag. Default: NULL}

\item{threads}{Number of threads to run in parallel. Default: 1}
}
\value{
None
}
\description{
Run PARADIGM on multi-omic data
}
\examples{

freal = system.file('extdata/TcgaInp/inp_real.rds', package='MPAC')
real_se  = readRDS(freal)

fpth = system.file('extdata/Pth/tiny_pth.txt', package='MPAC')
outdir = tempdir()
paradigm_bin = '/path/to/PARADIGM'  ## change to binary location

# depends on external PARADIGM binary
runPrd(real_se, fpth, outdir, paradigm_bin, sampleids=c('TCGA-CV-7100'))

}
