% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pltSttKM.R
\name{pltSttKM}
\alias{pltSttKM}
\title{Plot a Kaplan-Meier curve for samples stratified by given
protein(s)' pathway states}
\usage{
pltSttKM(
  cdrmat,
  fltmat,
  event = "OS",
  time = "OS_days",
  proteins = NULL,
  strat_func = ">0"
)
}
\arguments{
\item{cdrmat}{A matrix containing survival data with rows as patient
samples and columns as survival event and time.}

\item{fltmat}{A matrix contains filterd IPL with rows as entity and
column as samples. This is the output from \code{fltByPerm()}.
Entity with NA value will be set to 0 and plotted as in
'normal' state.}

\item{event}{The column name in \code{cdrmat} to indicate survival event.
Default: 'OS'.}

\item{time}{The column name in \code{cdrmat} to indicate survival time.
Default: 'OS_days'.}

\item{proteins}{Rowname(s) in \code{fltmat}. Its/their pathway states will be
used to stratify patient samples. Default: all proteins
in \code{fltmat} will be used.}

\item{strat_func}{A function applied on protein(s) pathway states to
stratify patient samples. Available options: '>0', '<0',
Default: '>0', i.e., IPL >0 vs. the rest.}
}
\value{
A Kaplan-Meier plot
}
\description{
Plot a Kaplan-Meier curve for samples stratified by given
protein(s)' pathway states
}
\examples{

cdrmat <- system.file('extdata/pltSttKM/cdr.rds',package='MPAC') |> readRDS()
fltmat <- system.file('extdata/pltSttKM/ipl.rds',package='MPAC') |> readRDS()

pltSttKM(cdrmat, fltmat, event='OS', time='OS_days',
         proteins=c('CD247', 'FASLG'))

}
