% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataProcessPTM.R
\name{dataProcessPTM}
\alias{dataProcessPTM}
\title{Data processing and summarization of peptide-level quantification to PTM and protein level quantification}
\usage{
dataProcessPTM(
  data,
  ptm_label_type,
  protein_label_type,
  MBimpute_ptm = FALSE,
  MBimpute_protein = TRUE,
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL,
  ...
)
}
\arguments{
\item{data}{Name of the output of MSstatsPTM converter function or
peptide-level quantified data from other tools. It should be a list
containing one or two data tables, named PTM and PROTEIN for modified and
unmodified datasets. The list must at least contain the PTM dataset, however
the PROTEIN dataset is optional.}

\item{ptm_label_type}{Indicator of labeling type for PTM dataset. Must be one of
\code{LF} or \code{TMT}}

\item{protein_label_type}{Indicator of labeling type for PROTEIN dataset. Must be
one of \code{LF} or \code{TMT}}

\item{MBimpute_ptm}{Missing value imputation on the feature-level for the PTM
dataset. TRUE (default) imputes missing values by Accelated
failure model. FALSE uses minimum value to impute the missing value for each
peptide precursor ion.}

\item{MBimpute_protein}{Missing value imputation on the feature-level for the
PROTEIN dataset. TRUE (default) imputes missing values by Accelated
failure model. FALSE uses minimum value to impute the missing value for each
peptide precursor ion.}

\item{...}{Additional parameters passed to either the
\link[MSstats]{dataProcess} function from \code{MSstats} or the
\link[MSstatsTMT]{proteinSummarization} function from \code{MSstatsTMT}.}
}
\description{
Function to perform data processing and summarization on an experiment
targeting post-translational modifications. Performs normalization, missing
value imputation, feature selection, and summarization. Can optionally take
an additional global protein quantification experiment for protein-level
correction of PTM changes. Can take either label free or tandem mass tag
(TMT) labeled data.
}
