% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDoc.R
\docType{data}
\name{summary.data.tmt}
\alias{summary.data.tmt}
\title{Example of output from dataSummarizationPTM_TMT function for TMT data}
\format{
A list of two lists with four data.tables.
}
\usage{
summary.data.tmt
}
\description{
It is made from \code{\link{raw.input.tmt}}.
It is the output of dataSummarizationPTM_TMT function from MSstatsPTM.
It should include a list with two names \code{PTM} and \code{PROTEIN}. Each
of these list values is also a list with two names \code{ProteinLevelData}
and \code{FeatureLevelData}, which correspond to two data.tables.The columns
in these two data.tables are listed below. The variables are as follows:
\itemize{
\item FeatureLevelData : \itemize{
\item ProteinName : MS run ID
\item PSM : Protein ID with modification site mapped in. Ex.
Protein_1002_S836
\item censored: Protein-level summarized abundance
\item predicted : Labeling information (126, ... 131)
\item log2Intensity : Condition (ex. Healthy, Cancer, Time0)
\item Run : Unique ID for biological subject.
\item Channel : Unique ID for technical replicate of one TMT
mixture.
\item BioReplicate : Unique ID for TMT mixture.
\item Condition : Unique ID for TMT mixture.
\item Mixture : Unique ID for TMT mixture.
\item TechRepMixture : Unique ID for TMT mixture.
\item PeptideSequence : Unique ID for TMT mixture.
\item Charge : Unique ID for TMT mixture.
}
\item ProteinLevelData : \itemize{
\item Mixture : MS run ID
\item TechRepMixture : Protein ID with modification site mapped in. Ex.
Protein_1002_S836
\item Run: Protein-level summarized abundance
\item Channel : Labeling information (126, ... 131)
\item Protein : Condition (ex. Healthy, Cancer, Time0)
\item Abundance : Unique ID for biological subject.
\item BioReplicate : Unique ID for technical replicate of one TMT
mixture.
\item Condition : Unique ID for TMT mixture.
}

}
}
\examples{
head(summary.data.tmt)

}
\keyword{datasets}
