% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IC50_prediction.R
\name{bootstrapIC50LogScale}
\alias{bootstrapIC50LogScale}
\title{Bootstrap IC50 Estimates and Confidence Interval (log scale)}
\usage{
bootstrapIC50LogScale(
  x,
  y,
  n_samples = 1000,
  alpha = 0.05,
  increasing = FALSE,
  target_response = 0.5
)
}
\arguments{
\item{x}{Numeric vector of dose values.}

\item{y}{Numeric vector of log2 response values.}

\item{n_samples}{Number of bootstrap samples (default = 1000).}

\item{alpha}{Significance level for confidence interval (default = 0.05).}

\item{increasing}{Logical. Fit non-decreasing if TRUE.}

\item{target_response}{Numeric value for response level (default = 0.5).}
}
\value{
List with mean IC50, CI bounds, and transformed estimates.
}
\description{
Bootstrap IC50 Estimates and Confidence Interval (log scale)
}
