% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExperimentalDesignSimulation.R
\name{simulateChemoProteinLevelNonParametric}
\alias{simulateChemoProteinLevelNonParametric}
\title{Simulate chemoproteomics data at the protein level - non-parametric approach}
\usage{
simulateChemoProteinLevelNonParametric(
  N_proteins = 3000,
  TP = 0.333,
  TW = 0.333,
  TN = 0.333,
  concentrations = c(0, 1, 3, 10, 30, 100, 300, 1000, 3000),
  rep = 3,
  seed = NULL,
  var_tech = 0.4,
  control_rep = NULL,
  template = list(strong_interaction = data.frame(dose = c(), LogIntensities = c()),
    weak_interaction = data.frame(dose = c(), LogIntensities = c()), no_interaction =
    data.frame(dose = c(), LogIntensities = c())),
  outlier_prob = 0.05
)
}
\arguments{
\item{N_proteins}{Number of proteins in simulation. Default = 3000.}

\item{TP}{Proportion of strong interacting proteins. Default = 0.333.}

\item{TW}{Proportion of weak interacting proteins. Default = 0.333.}

\item{TN}{Proportion of non-interacting proteins. Default = 0.333.}

\item{concentrations}{Numeric vector of drug concentrations in simulation experiment.
Default = c(0, 1, 3, 10, 30, 100, 300, 1000, 3000).}

\item{rep}{Number of replicates for each drug concentration. Default = 3.}

\item{seed}{Simulation seed for reproducibility. Default = 3.}

\item{var_tech}{Combined technical and biological variation. Default = 0.4.}

\item{control_rep}{Number of control replicates. If NULL, uses rep.}

\item{template}{List containing real protein level data representing different
levels of interactions.}

\item{outlier_prob}{Probability of sample outlier. Default = 0.05.}
}
\value{
A data.frame with simulated chemoproteomics data.
}
\description{
Simulate chemoproteomics data at the protein level - non-parametric approach
}
