% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupComparisonPlots.R
\name{.plotHeatmap}
\alias{.plotHeatmap}
\title{Prepare data for heatmaps and plot them}
\usage{
.plotHeatmap(
  input,
  log_base_pval,
  ylimUp,
  FCcutoff,
  sig,
  clustering,
  numProtein,
  colorkey,
  width,
  height,
  log_base_FC,
  x.axis.size,
  y.axis.size,
  address,
  isPlotly
)
}
\arguments{
\item{input}{data.table}

\item{log_base_pval}{log base for p-values}

\item{ylimUp}{for all three plots, upper limit for y-axis. FALSE (default) for volcano plot/heatmap use maximum of -log2 (adjusted p-value) or -log10 (adjusted p-value). FALSE (default) for comparison plot uses maximum of log-fold change + CI.}

\item{FCcutoff}{for volcano plot or heatmap, whether involve fold change cutoff or not. FALSE (default) means no fold change cutoff is applied for significance analysis. FCcutoff = specific value means specific fold change cutoff is applied.}

\item{sig}{FDR cutoff for the adjusted p-values in heatmap and volcano plot. level of significance for comparison plot. 100(1-sig)\% confidence interval will be drawn.  sig=0.05 is default.}

\item{clustering}{Determines how to order proteins and comparisons. Hierarchical cluster analysis with Ward method(minimum variance) is performed. 'protein' means that protein dendrogram is computed and reordered based on protein means (the order of row is changed). 'comparison' means comparison dendrogram is computed and reordered based on comparison means (the order of comparison is changed). 'both' means to reorder both protein and comparison. Default is 'protein'.}

\item{numProtein}{For ggplot2: The number of proteins which will be presented in each heatmap. Default is 100. Maximum possible number of protein for one heatmap is 180.
For Plotly: use this parameter to adjust the number of proteins to be displayed on the heatmap}

\item{colorkey}{TRUE(default) shows colorkey.}

\item{width}{width of the saved file in pixels. Default is 800.}

\item{height}{height of the saved file in pixels. Default is 600.}

\item{log_base_FC}{log base for log-fold changes - 2 or 10}

\item{x.axis.size}{size of axes labels, e.g. name of the comparisons in heatmap, and in comparison plot. Default is 10.}

\item{y.axis.size}{size of axes labels, e.g. name of targeted proteins in heatmap. Default is 10.}

\item{address}{the name of folder that will store the results. Default folder is the current working directory. The other assigned folder has to be existed under the current working directory. An output pdf file is automatically created with the default name of "VolcanoPlot.pdf" or "Heatmap.pdf" or "ComparisonPlot.pdf". The command address can help to specify where to store the file as well as how to modify the beginning of the file name. If address=FALSE, plot will be not saved as pdf file but showed in window.}

\item{isPlotly}{This parameter is for MSstatsShiny application for plotly 
render, this cannot be used for saving PDF files as plotly do not have 
suppprt for PDFs currently. address and isPlotly cannot be set as TRUE at the
same time.}
}
\description{
Prepare data for heatmaps and plot them
}
\keyword{internal}
