% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_checks.R
\name{makePeptidesDictionary}
\alias{makePeptidesDictionary}
\title{Prepare a peptides dictionary for global standards normalization}
\usage{
makePeptidesDictionary(input, normalization)
}
\arguments{
\item{input}{`data.table` in MSstats standard format}

\item{normalization}{normalization method}
}
\description{
Prepare a peptides dictionary for global standards normalization
}
\details{
This function extracts information required to perform normalization
with global standards. It is useful for running the summarization workflow
outside of the dataProcess function.
}
\examples{
input = data.table::as.data.table(DDARawData)
peptides_dict = makePeptidesDictionary(input, "GLOBALSTANDARDS")
head(peptides_dict) # ready to be passed to the MSstatsNormalize function

}
