% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_Spectra_metrics.R
\name{msSignal10xChange}
\alias{msSignal10xChange}
\title{MS1 signal jump (10x) count (MS:4000097) or MS1 signal fall (10x) 
count (MS:4000098)}
\usage{
msSignal10xChange(spectra, change = "jump", msLevel = 1L, ...)
}
\arguments{
\item{spectra}{\code{Spectra} object}

\item{change}{\code{character(1)}, one of \code{"jump"} or \code{"fall"}}

\item{msLevel}{\code{integer}}

\item{...}{not used here}
}
\value{
\code{numeric(1)}
}
\description{
MS:4000097 \cr
"The number of times where MS1 TIC increased more than 10-fold between 
adjacent MS1 scans. An unusual high count of signal jumps or falls can 
indicate ESI stability issues." [PSI:MS] \cr

MS:4000098 \cr
"The number of times where MS1 TIC decreased more than 10-fold between 
adjacent MS1 scans. An unusual high count of signal jumps or falls can 
indicate ESI stability issues." [PSI:MS] \cr

The metric is calculated as follows: \cr
(1) the \code{Spectra} object is filtered according to the MS level, \cr 
(2) the intensity of the precursor ions within the \code{Spectra} object are 
obtained, \cr 
(3) the intensity values of the features are obtained via the ion count, \cr 
(4) the signal jumps/declines of the intensity values with the two 
subsequent intensity values is calculated, \cr 
(5) in the case of *MS:4000097*, the signal jumps by a factor of ten or more
are counted and returned; \cr
in the case of *MS:4000098*, the signal declines by a factor of ten or more
are counted and returned. \cr
}
\details{
MS:4000097 \cr
is_a: MS:4000003 ! single value \cr
relationship: has_metric_category MS:4000009 ! ID free metric \cr
relationship: has_metric_category MS:4000021 ! MS1 metric \cr
relationship: has_units UO:0000189 ! count unit \cr
relationship: has_value_type xsd:integer ! The allowed value-type for this CV 
term \cr
synonym: "IS-1A"  RELATED [] \cr

MS:4000098 \cr
is_a: MS:4000003 ! single value \cr
relationship: has_metric_category MS:4000009 ! ID free metric \cr
relationship: has_metric_category MS:4000021 ! MS1 metric \cr
relationship: has_units UO:0000189 ! count unit \cr
relationship: has_value_type xsd:integer ! The allowed value-type for this CV
term \cr
synonym: "IS-1B"  RELATED [] \cr
 
The function \code{msSignal10xChange} uses the function \code{ionCount} as an 
equivalent to the TIC.

An attribute containing the PSI:MS term will only be returned if 
\code{msLevel} is 1.
}
\examples{
library(S4Vectors)
library(Spectra)

spd <- DataFrame(
    msLevel = c(2L, 2L, 2L),
    polarity = c(1L, 1L, 1L),
    id = c("HMDB0000001", "HMDB0000001", "HMDB0001847"),
    name = c("1-Methylhistidine", "1-Methylhistidine", "Caffeine"))
## Assign m/z and intensity values
spd$mz <- list(
    c(109.2, 124.2, 124.5, 170.16, 170.52),
    c(83.1, 96.12, 97.14, 109.14, 124.08, 125.1, 170.16),
    c(56.0494, 69.0447, 83.0603, 109.0395, 110.0712,
        111.0551, 123.0429, 138.0662, 195.0876))
spd$intensity <- list(
    c(3.407, 47.494, 3.094, 100.0, 13.240),
    c(6.685, 4.381, 3.022, 16.708, 100.0, 4.565, 40.643),
    c(0.459, 2.585, 2.446, 0.508, 8.968, 0.524, 0.974, 100.0, 40.994))
spd$rtime <- c(9.44, 9.44, 15.84)
sps <- Spectra(spd)
msSignal10xChange(spectra = sps, change = "jump", msLevel = 2L)
msSignal10xChange(spectra = sps, change = "fall", msLevel = 2L)
}
\author{
Thomas Naake
}
