% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_Spectra_metrics.R
\name{rtIqrRate}
\alias{rtIqrRate}
\title{rate of the interquartile RT period for identified quantification 
data points (MS:4000154)}
\usage{
rtIqrRate(
  spectra,
  msLevel = 1L,
  identificationLevel = c("all", "identified", "unidentified"),
  ...
)
}
\arguments{
\item{spectra}{\code{Spectra} object}

\item{msLevel}{\code{integer}}

\item{identificationLevel}{\code{character(1)}, one of \code{"all"}, 
\code{"identified"}, or \code{"unidentified"}}

\item{...}{not used here}
}
\value{
\code{numeric(2)}
}
\description{
MS:4000154 \cr
"The rate of identified quantification data points for the interquartile 
retention time period, in identified quantification data points per second. 
Higher rates indicate efficient sampling and identification. These data 
points may be for example XIC profiles, isotopic pattern areas, or reporter 
ions (see MS:1001805). The used type should be noted in the metadata or 
analysis methods section of the recording file for the respective run. In 
case of multiple acceptance criteria (FDR) available in proteomics, PSM-level 
FDR should be used for better comparability." [PSI:MS]\cr

The metric is calculated as follows: \cr
(1) the \code{Spectra} object is filtered according to the MS level, \cr 
(2) the retention time values are obtained, \cr 
(3) the 25\% and 75\% quantiles are obtained from the retention time values
(\code{NA} values are removed), \cr 
(4) the number of eluted features between this 25\% and 75\% quantile is 
calculated, \cr 
(5) the number of features is divided by the interquartile range of the 
retention time and returned. \cr
}
\details{
MS:4000154 \cr
is_a: MS:4000003 ! single value \cr
is_a: MS:4000008 ! ID based \cr
is_a: MS:4000017 ! chromatogram metric \cr
relationship: has_units UO:0000106 ! hertz
synonym: "C-2B"  RELATED [PMID:19837981] \cr

An attribute containing the PSI:MS term will only be returned if 
\code{identificationLevel} is \code{"identified"}.
}
\note{
The \code{Spectra} object might contain features that were not identified. If
the calculation needs to be done according to *MS:4000154*, the 
\code{Spectra} object should be prepared accordingly, i.e. being subsetted to
\code{spectra} with identification data.

The stored retention time information in \code{spectra} might have a different
unit than seconds. \code{.rtIqr} will return the IQR based on the values stored
in \code{spectra} and will not convert these values to seconds.
}
\examples{
library(S4Vectors)
library(Spectra)

spd <- DataFrame(
    msLevel = c(2L, 2L, 2L),
    polarity = c(1L, 1L, 1L),
    id = c("HMDB0000001", "HMDB0000001", "HMDB0001847"),
    name = c("1-Methylhistidine", "1-Methylhistidine", "Caffeine"))
## Assign m/z and intensity values
spd$mz <- list(
    c(109.2, 124.2, 124.5, 170.16, 170.52),
    c(83.1, 96.12, 97.14, 109.14, 124.08, 125.1, 170.16),
    c(56.0494, 69.0447, 83.0603, 109.0395, 110.0712,
        111.0551, 123.0429, 138.0662, 195.0876))
spd$intensity <- list(
    c(3.407, 47.494, 3.094, 100.0, 13.240),
    c(6.685, 4.381, 3.022, 16.708, 100.0, 4.565, 40.643),
    c(0.459, 2.585, 2.446, 0.508, 8.968, 0.524, 0.974, 100.0, 40.994))
spd$rtime <- c(9.44, 9.44, 15.84)
sps <- Spectra(spd)
rtIqrRate(spectra = sps, msLevel = 2L)
}
\author{
Thomas Naake
}
