% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterProfile.R
\name{clusterDataDend}
\alias{clusterDataDend}
\title{Create a hclust object from the distance matrix}
\usage{
clusterDataDend(distanceMatrix = NULL, clusterMethod = "complete")
}
\arguments{
\item{distanceMatrix}{calculated distance matrix as dist object}

\item{clusterMethod}{clustering method ("single", "complete",
"average" for UPGMA, "mcquitty" for WPGMA, "median" for WPGMC,
or "centroid" for UPGMC). Default = "complete".}
}
\value{
An object class hclust generated based on input distance matrix and
a selected clustering method.
}
\description{
Create a hclust object from the distance matrix
}
\examples{
data("finalProcessedProfile", package="PhyloProfile")
data <- finalProcessedProfile
profileType <- "binary"
profiles <- getDataClustering(
    data, profileType, var1AggregateBy, var2AggregateBy)
distMethod <- "mutualInformation"
distanceMatrix <- getDistanceMatrix(profiles, distMethod)
clusterMethod <- "complete"
clusterDataDend(as.dist(distanceMatrix), clusterMethod)
}
\seealso{
\code{\link{getDataClustering}},
\code{\link{getDistanceMatrix}}, \code{\link{hclust}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
