% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseMainInput.R
\name{createLongMatrix}
\alias{createLongMatrix}
\title{Create a long matrix format for all kinds of input phylogenetic profiles}
\usage{
createLongMatrix(inputFile = NULL)
}
\arguments{
\item{inputFile}{input profile file in orthoXML, multiple FASTA,
tab-delimited matrix format (wide or long).}
}
\value{
A data frame of input data in long-format containing seed gene IDs (
or orthologous group IDs), their orthologous proteins together with the
corresponding taxonomy IDs and values of (up to) two additional variables.
}
\description{
Create a long matrix format for all kinds of input phylogenetic profiles
}
\examples{
inputFile <- system.file(
    "extdata", "test.main.wide", package = "PhyloProfile", mustWork = TRUE
)
createLongMatrix(inputFile)
}
\seealso{
\code{\link{xmlParser}}, \code{\link{fastaParser}},
\code{\link{wideToLong}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
