% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RAIDS.R
\docType{data}
\name{demoKnownSuperPop1KG}
\alias{demoKnownSuperPop1KG}
\title{The known super population ancestry of the demo 1KG reference profiles.}
\format{
The \code{vector} containing the know super population ancestry
for the demo 1KG reference profiles.
}
\usage{
data(demoKnownSuperPop1KG)
}
\value{
The \code{vector} containing the know super population ancestry
for the demo 1KG reference profiles.
}
\description{
The object is a \code{vector}.
}
\details{
This object can be
used to test the \code{\link{computeKNNRefSynthetic}} and
\code{\link{computePoolSyntheticAncestryGr}} functions.
}
\examples{

## Required library
library(gdsfmt)

## Load the demo PCA on the synthetic profiles projected on the
## demo 1KG reference PCA
data(demoPCASyntheticProfiles)

## Load the known ancestry for the demo 1KG reference profiles
data(demoKnownSuperPop1KG)

## Path to the demo Profile GDS file is located in this package
dataDir <- system.file("extdata/demoKNNSynthetic", package="RAIDS")

## Open the Profile GDS file
gdsProfile <- snpgdsOpen(file.path(dataDir, "ex1.gds"))

# The name of the synthetic study
studyID <- "MYDATA.Synthetic"

## Projects synthetic profiles on 1KG PCA
results <- computeKNNRefSynthetic(gdsProfile=gdsProfile,
    listEigenvector=demoPCASyntheticProfiles,
    listCatPop=c("EAS", "EUR", "AFR", "AMR", "SAS"), studyIDSyn=studyID,
    spRef=demoKnownSuperPop1KG)

## The inferred ancestry for the synthetic profiles for different values
## of D and K
head(results$matKNN)

## Close Profile GDS file (important)
closefn.gds(gdsProfile)

}
\seealso{
\describe{
\item{\code{\link{computeKNNRefSynthetic}}}{ for running a k-nearest
neighbors analysis on a subset of the synthetic data set.}
\item{\code{\link{computePoolSyntheticAncestryGr}}}{ for running a
PCA analysis using 1 synthetic profile from each sub-continental
population.}
}
}
\keyword{datasets}
