% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process1KG_internal.R
\encoding{UTF-8}
\name{validatePrepPed1KG}
\alias{validatePrepPed1KG}
\title{Validate input parameters for prepPed1KG() function}
\usage{
validatePrepPed1KG(filePed, pathGeno, batch)
}
\arguments{
\item{filePed}{a \code{character} string representing the path and
file name of the pedigree file (PED file) that contains the information
related to the profiles present in the 1KG GDS file. The PED file must
exist.}

\item{pathGeno}{a \code{character} string representing the path where
the Reference genotyping files for each profile are located. Only the
profiles with associated genotyping files are retained in the creation of
the final \code{data.frame}. The name of the genotyping files must
correspond to the individual identification (Individual.ID) in the
pedigree file (PED file).}

\item{batch}{a\code{integer} that uniquely identifies the source of the
pedigree information. The Reference is usually \code{0L}.}
}
\value{
The function returns \code{0L} when successful.
}
\description{
This function validates the input parameters for the
\code{\link{prepPed1KG}} function.
}
\examples{

## Directory where demo GDS files are located
dataDir <- system.file("extdata", package="RAIDS")

## Demo pedigree file
pedDemoFile <- file.path(dataDir, "PedigreeDemo.ped")

## The validation should be successful
RAIDS:::validatePrepPed1KG(filePed=pedDemoFile,
     pathGeno=dataDir, batch=1)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
