% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_permanova.R
\name{permanova}
\alias{permanova}
\title{Perform a PERMANOVA analysis for group differences of a predefined cofactor using the pseudo F-statistic}
\usage{
permanova(
  rcmObj,
  groups,
  nPerm = 10000,
  Dim = seq_len(rcmObj$k),
  verbose = TRUE
)
}
\arguments{
\item{rcmObj}{an RCM object}

\item{groups}{a factor of length n with cluster memberships, or a name of a variable contained in the RCM object}

\item{nPerm}{Number of permutations in the PERMANOVA}

\item{Dim}{Dimensions on which the test should be performed. Defaults to all dimensions of the fitted RCM object.}

\item{verbose}{a boolean, should output be printed?}
}
\value{
A list with components
\item{statistic}{The pseudo F-statistic}
\item{p.value}{The p-value of the PERMANOVA}
}
\description{
Perform a PERMANOVA analysis for group differences of a predefined cofactor using the pseudo F-statistic
}
\examples{
data(Zeller)
require(phyloseq)
tmpPhy = prune_taxa(taxa_names(Zeller)[1:100],
prune_samples(sample_names(Zeller)[1:50], Zeller))
zellerRCM = RCM(tmpPhy, round = TRUE)
zellerPermanova = permanova(zellerRCM, "Diagnosis")
}
\seealso{
\code{\link{RCM}}
}
