% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetOneRadiusEntropy_withProp.R
\name{GetOneRadiusEntropy_withProp}
\alias{GetOneRadiusEntropy_withProp}
\title{Computer the entropy for a fixed radius with cell type proportion}
\usage{
GetOneRadiusEntropy_withProp(
  sce,
  selectN,
  weight = NULL,
  label = "celltype",
  radius = 10,
  doPlot = FALSE,
  mytitle = NULL
)
}
\arguments{
\item{sce}{A single cell experiment object.}

\item{selectN}{A total number for selected centers. Should be smaller than the total site number.}

\item{weight}{A data frame to specify the weights of all cell types.}

\item{label}{A variable name that contains the cell type information.}

\item{radius}{A number for fixed radius.}

\item{doPlot}{Logical variable about whether draw the plot.}

\item{mytitle}{A character string for the title of the plot.}
}
\value{
A list including the selected centers, computed entropies, radius.
}
\description{
Computer the entropy for a fixed radius with cell type proportion
}
\examples{
data("example_sce")
weight <- data.frame(celltype = c("Cancer Epithelial", "CAFs", "T-cells", "Endothelial",
                                "PVL", "Myeloid", "B-cells", "Normal Epithelial", "Plasmablasts"),
                     weight = c(0.25,0.05,
                                0.25,0.05,
                                0.025,0.05,
                                0.25,0.05,0.025))
example_sce <- mySpatialPreprocess(example_sce, platform="Visium")
example_sce$"array_col" <- example_sce$col
example_sce$"array_row" <- example_sce$row
example_sce$"pxl_col_in_fullres" <- example_sce$imagecol
example_sce$"pxl_row_in_fullres" <- example_sce$imagerow
GetOneRadiusEntropy_withProp(example_sce, selectN = round(length(example_sce$spot)/10),
                             weight = weight,
                             radius = 5,
                             doPlot = TRUE,
                             mytitle = "Radius 5 weighted entropy")

}
