% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_transcription_rates-class.R
\docType{class}
\name{SimulationTranscriptionRates-class}
\alias{SimulationTranscriptionRates-class}
\alias{estimateTranscriptionRates,SimulatePolymerase-method}
\alias{show,SimulationTranscriptionRates-method}
\alias{simpol}
\alias{simpol,SimulationTranscriptionRates-method}
\alias{stericHindrance,SimulationTranscriptionRates-method}
\alias{rates,SimulationTranscriptionRates-method}
\title{Constructor for SimulationTranscriptionRates object}
\usage{
\S4method{estimateTranscriptionRates}{SimulatePolymerase}(x, name, stericHindrance = FALSE)

\S4method{show}{SimulationTranscriptionRates}(object)

simpol(object)

\S4method{simpol}{SimulationTranscriptionRates}(object)

\S4method{stericHindrance}{SimulationTranscriptionRates}(object)

\S4method{rates}{SimulationTranscriptionRates}(object)
}
\arguments{
\item{x}{a \code{\linkS4class{SimulatePolymerase}} object}

\item{name}{a string providing information about the simulation}

\item{stericHindrance}{a logical value to determine whether to infer
landing-pad occupancy or not. Defaults to FALSE.}

\item{object}{a \code{SimulationTranscriptionRates} object}
}
\value{
a \code{\linkS4class{SimulationTranscriptionRates}} object
}
\description{
Class containing the simulated data, such as the nascent RNA sequencing reads
sampled from the simulated polymerase movement in the
\code{SimulatePolymerase} object. It also contains the estimated average
read depths along the gene body and pause regions, given fixed or varied
pause sites, as well as the landing pad occupancy estimate. These can be
under a model with or without steric hindrance.

Estimates transcription rates from a SimulatePolymerase object using
Expectation Maximization likelihood formula.

Show method for SimulationTranscriptionRates object in human readable format
including summary statistics

Accessor for the SimulatePolymerase object from a
SimulationTranscriptionRates object.

Accessor for the steric hindrance flag from a
SimulationTranscriptionRates object.

Accessor for the tibble containing the estimated rates from a
SimulationTranscriptionRates object.
}
\section{Slots}{

\describe{
\item{\code{simpol}}{a \code{\linkS4class{SimulatePolymerase}} object}

\item{\code{name}}{a character value for the name of the experiment}

\item{\code{stericHindrance}}{a logical value to determine whether to infer
landing-pad occupancy or not. Defaults to FALSE.}

\item{\code{rates}}{a \code{\link[tibble]{tbl_df}} containing the estimated rates
with columns:
\describe{
\item{trial}{Numeric. Trial number, each trial samples 5000 cells}
\item{chi}{Numeric. RNAP density along gene body given as estimate for the
gene body elongation rate \verb{[RNAPs/bp]}}
\item{betaOrg}{Numeric. Ratio of gene body RNAP density to pause region
RNAP density with fixed pause sites given as an estimate for the
pause-escape rate}
\item{betaAdp}{Numeric. Ratio of gene body RNAP density to pause region
RNAP density from adapted model which allows pause sites to vary across
cells given as an estimate for the pause-escape rate}
\item{phi}{Numeric. Landing-pad occupancy representing the fraction of time
in the simulation that the landing pad is occupied by RNA polymerase. The
landing pad, also known as the initiation site, is the region where the RNA
polymerase binds to the DNA and begins transcription. It is the polSize +
addSpace length (only applicable if steric hindrance is enabled)}
\item{fk}{list. Likelihood of pausing at each pause region position}
\item{fkMean}{Numeric. Mean position of pause sites}
\item{fkVar}{Numeric. Variance of pause site positions}
\item{totalTssRc}{Numeric. Total RNAP read counts in the TSS region (across
all cells)}
\item{totalGbRc}{Numeric. Total RNAP read counts in the gene body region
(across all cells)}
\item{totalLandingRc}{Numeric. Total RNAP read counts in the landing pad
region (across all cells)}
\item{avgRcPerCell}{Numeric. Average number of RNAPs per cell for gene
body and TSS regions}
\item{avgTssRcPerCell}{Numeric. Average number of RNAPs per cell for
pause regions (across all cells)}
\item{avgLandingRcPerCell}{Numeric. Average number of RNAPs per cell for
landing pad regions (across all cells)}
\item{actualPauseSiteCounts}{list. Simulated pause site counts for each
cell}
\item{expectedPauseSiteCounts}{list. Expected pause site counts for each
cell estimated from the EM algorithm}
\item{expectationMaximizationStatus}{character. Status of the expectation
maximization algorithm. "normal": converged normally, "single_site":
converged to single pause site, "max_iterations": reached maximum
iterations without convergence. Note max # of iterations is 500.}
\item{likelihood}{a numeric vector of the likelihood of the model}
}}
}}

\examples{
# Create a SimulatePolymerase object
sim <- simulatePolymerase(
    k = 50, ksd = 25, kMin = 17, kMax = 200, geneLen = 1950,
    alpha = 1, beta = 1, zeta = 2000, zetaSd = 1000, zetaMin = 1500,
    zetaMax = 2500, zetaVec = NULL, cellNum = 100, polSize = 33,
    addSpace = 17, time = 1)
# Estimate transcription rates
estRates <- estimateTranscriptionRates(sim, name="sim_beta1_k50")
# Print the estimated rates
print(estRates)

}
