% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCSRNoNet-class.R
\docType{class}
\name{SCSRNoNet-class}
\alias{SCSRNoNet-class}
\title{SingleCellSignalR no network object}
\description{
An S4 class to represent data and naive, network-free inferences
of ligand-receptor interactions. Both
autocrine and paracrine interactions can be inferred and explored.
The absence of receptor network downstream exploration makes computations
fast, but the quality of the inferences is worse than those
obtained using the SCSRNet class.
}
\details{
This class is a container for all the data and inferences
related to a given single-cell project.
}
\section{Slots}{

\describe{
\item{\code{bsrdm.comp}}{A BulkSignalR BSRDataModelComp object containing
the expression matrix data as well as the comparisons between cell
populations.}

\item{\code{populations}}{A vector defining the cell population to which
each individual cell belongs to. The length of this vector must
be equal to the number of columns of the expression matrix.}

\item{\code{paracrines}}{A list of data.frames
containing all the paracrine ligand-receptor interactions between
all the possible pairs of cell populations.}

\item{\code{autocrines}}{A list of data.frames
containing all the autocrine ligand-receptor interactions for
each cell population.}

\item{\code{inf.param}}{Inference parameters.}
}}

\examples{
print("Create SCSRNet object:")
data(example_dataset, package = "SingleCellSignalR")
mat <- log1p(data.matrix(example_dataset[, -1])) / log(2)
rownames(mat) <- example_dataset[[1]]
rme <- rowMeans(mat)
mmat <- mat[rme > 0.05, ]
d <- dist(t(mmat))
h <- hclust(d, method = "ward.D")
pop <- paste0("pop_", cutree(h, 5))
scsrnn <- SCSRNoNet(mat,
    populations = pop, normalize = FALSE,
    method = "log-only", log.transformed = TRUE
)
}
