% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataImport.R
\name{readExperimentDIA}
\alias{readExperimentDIA}
\title{Read and Process a DIA Experiment}
\usage{
readExperimentDIA(
  fileTable,
  localProbCut = 0.75,
  annotation_col = c(),
  onlyReviewed = TRUE,
  normalizeByProtein = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{fileTable}{A \code{data frame} containing metadata about the files to
be read. Must contain columns searchType, fileName, id, and optionally
outputID.}

\item{localProbCut}{\code{Numeric}, the local probability cutoff for
phosphoproteomic data. Default is 0.75.}

\item{annotation_col}{A \code{character} vector specifying the columns in
fileTable to be used for sample annotation.}

\item{onlyReviewed}{A \code{logical} value indicating whether to include
only reviewed proteins. Default is \code{TRUE}.}

\item{normalizeByProtein}{\code{Logical}, whether to normalize the data by
protein. Default is \code{FALSE}.}

\item{verbose}{\code{Logical} value indicating whether to print detailed
information. Default is \code{FALSE}.}
}
\value{
A \code{MultiAssayExperiment} object containing the processed
phosphoproteome and proteome data.
}
\description{
\code{readExperimentDIA} reads and processes DIA (Data-Independent
Acquisition) data for both phosphoproteome and proteome experiments, and
constructs a \code{MultiAssayExperiment} object.
}
\details{
The function performs the following steps:
\itemize{
  \item Reads and processes phosphoproteomic data using
  \code{readPhosphoExperimentDIA}.
  \item Reads and processes proteomic data using
  \code{readProteomeExperimentDIA}.
  \item Prepares sample annotations based on the provided fileTable and
  annotation_col.
  \item Constructs a \code{MultiAssayExperiment} object with the processed
  data and sample annotations.
}
The \code{readPhosphoExperimentDIA} and \code{readProteomeExperimentDIA}
functions are used to read and filter the data for phosphoproteome and
proteome experiments, respectively, and they must be available in the
environment.
}
\examples{
# Example usage:
file1 <- system.file("extdata", "phosDIA_1.xls", package = "SmartPhos")
file2 <- system.file("extdata", "proteomeDIA_1.xls", package = "SmartPhos")
# Create fileTable
fileTable <- data.frame(
  searchType = c("phosphoproteome", "proteome", "proteome"),
  fileName = c(file1, file2, file2),
  id = c("Sample_1", "sample1", "sample2"),
  outputID = c("s1", "s2", "s3")
)
# Call the function
readExperimentDIA(fileTable, localProbCut = 0.75, annotation_col = c("id"),
onlyReviewed = FALSE, normalizeByProtein = FALSE)

}
